<?php


$app->get( '/locations_get_countries', function() use( $app, $db ) {
    $app->response()->header("Content-Type", "application/json");
		  $data = array();
	     foreach( $db->location->select('DISTINCT country') as $result ) {
		 
			 $data[] = array( 
			'country'         => $result['country']
        );
		 
		 }
	 echo json_encode( $data);
	
	});
	
	
$app->get( '/locations', function() use( $app, $db ) {
    $app->response()->header("Content-Type", "application/json");
  
	
	//echo ' Ndati id ine: '.$id;
	
  // $result = $db->location();
  
  //print_r($_SESSION);
   
       foreach( $db->location()->where("complete_location",1) as $result ) {
	
			$locationpayout = ""; 
			$payouts = [];
			foreach( $db->locationpayout()->where( 'location', $result['id'] ) as $payout_result ) {
		
			 $input = array(
									'id'         => $payout_result['id'], 
									'item'      => $payout_result['item'],
									'location'      => $payout_result['location'],
									'payout'      => $payout_result['value'],
									'start_amount'      => $payout_result['start_amount'],
									'end_amount'      => $payout_result['end_amount'],
									'value'      => $payout_result['value'],
									);
			array_push($payouts,$input);
			

		}
	//echo json_encode( $payouts);
	
		if (empty($locationpayout)){
			$locationpayout = "NOT CONFIGURED YET";
		}
        $data[] = array(
            'id'        => $result['id'],
            'location'    => $result['location'],
			'city'     => $result['city'],
			'country'  => $result['country'],
			'payoutratio'      => $payouts, 
			
        );
		
		
		
    }
	
    echo json_encode( $data);
});

//create data item  
$app->post( '/merge_location', function() use( $app, $db ) {
	$app->response()->header( "Content-Type", "application/json" );
	$data = $app->request()->post(); 
	$data = array( 'location' => $app->request()->post('location'),
					'city' => $app->request()->post('city'),
					'complete_location' => $app->request()->post('complete_location'),
					'country' => $app->request()->post('country') );
	$did = $app->request->post('did'); 
	 
	//echo json_encode( $data  );
	//We use this to add or update the user details
		if ($did == 0){
		  
		
			if ( $result = $db->location->insert($data) ) {
	 
						echo json_encode( array( 'message' => 'location created successfuly','success' => '1')  );
						//echo json_encode( $result);
	 
			} else {
				
				echo json_encode( array( 'message' => $result ,'success' => '0')  );
			}
		}else{
		
			//we use this to update the data
			 $row = $db->location()->where("ID", $did);
			 if ($row->fetch()) {
				if ( $result = $row->update($data) ) {
					echo json_encode( array( 'message' => 'location updated successfuly','success' => '1')  );
				}else {
					echo json_encode( array( 'message' => 'location update failed','success' => '0')  );
				}
			 }
		}
	}
);


$app->post( '/merge_location_payout', function() use( $app, $db ) {
	$app->response()->header( "Content-Type", "application/json" ); 
	
	$data = array( 	'item' 		=> $app->request()->post('item'),
					'value' 	=> $app->request()->post('value'),
					'location' 	=> $app->request->post('locationid'),
					'start_amount' 	=> $app->request->post('start'),
					'end_amount' 	=> $app->request->post('end')
					);
	$did = $app->request->post('did'); 
	$editLocationId = $app->request->post('locationid'); 
	 
	//echo json_encode( $data  );
	//die();
	//We use this to add or update the user details
		if ($_SESSION['action'] == "add"){
		  
		
			if ( $result = $db->locationpayout->insert($data) ) {
	 
						echo json_encode( array( 'message' => 'payout ratio created successfuly','success' => '1')  );
						//echo json_encode( $result);
	 
			} else {
				
				echo json_encode( array( 'message' => $result ,'success' => '0')  );
			}
		}else{
		
			$data = array( 	'item' 		=> $app->request()->post('item'),
					'value' 	=> $app->request()->post('value'), 
					'start_amount' 	=> $app->request->post('start'),
					'end_amount' 	=> $app->request->post('end')
					);
			
			 $row = $db->locationpayout()->where("id", $did );
			 if ($row->fetch()) {
				if ( $result = $row->update($data) ) {
					echo json_encode( array( 'message' => 'payout ratio  updated successfuly','success' => '1')  );
				}else {
					echo json_encode( array( 'message' => 'payout ratio  update failed','success' => '0')  );
				}
			 }
		}
	}
);

// get data by type
$app->get( '/city_by_country/:name', function( $name ) use( $app, $db ) {
    $app->response()->header("Content-Type", "application/json");
    $data = array();
	// echo json_encode( $name, JSON_FORCE_OBJECT );
 
    foreach( $db->location()->select('DISTINCT city')->where( 'country', $name ) as $result ) {
        $data[] = array(
            'city'         => $result['city'], 
        );
    }
	 
     echo json_encode( $data);
});


// get data by type
$app->get( '/location_by_city/:name', function( $name ) use( $app, $db ) {
		$app->response()->header("Content-Type", "application/json");
		$data = array();
	// echo json_encode( $name, JSON_FORCE_OBJECT );
 
    foreach( $db->location()->select('DISTINCT location')->where( 'city', $name ) as $result ) {
        $data[] = array(
            'location'         => $result['location'], 
        );
    }
	 
     echo json_encode( $data);


});




?>