<?php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include_once ("upload.php");
include_once ("website_helper.php");
include_once ("simple_html_dom.php");

$app->post('/create_website', function () use ($app, $db) {

    $team = $app->request()->post('team');
    $id = $app->request()->post('websiteid');
    $module = $app->request()->post('module');
    $moduleinfo = json_decode($app->request()->post('moduleinfo'));
    $website = $id;
    $response = array();
    //Lets insert the site into a list of websites available and 
    $str = time();
    $domain = md5($str);
    $domain = 'https://sites.gap365.co/' . $domain;

    $data = array(
        'website_app_id' => $website,
        'team' => $team,
        'domain' => $domain,
        'template' => $moduleinfo->template,
    );
    //Lets save to the database here 
    $db->websites->insert($data);
    $response = array('success' => 1, 'message' => "Website Successfully initiated");
    echo json_encode($response);
});


$app->post('/reset_gallery', function () use ($app, $db) {
    $app->response()->header("Content-Type", "application/json");
    $team = $app->request()->post('team');
    $website = $app->request()->post('websiteid');
    $response = array('success' => 0, 'message' => "Failed. Gallery does not exist");
    $row1 = $db->website_info()->where("site", $website)->where("team", $team)->where("module", "GALLERY_IMAGE");


    if ($s1 = $row1->fetch()) {

        $data = array("deleted" => 1);
        //$s1->update($data);
        $s1->delete();
        //TO DO GET ALL THE IMAGES HERE AND DELETE THEM 
        $response = array('success' => 1, 'message' => "Successfully reset Gallery");
    }

    echo json_encode($response);
});


$app->post('/get_module_display_order', function () use ($app, $db) {
    $app->response()->header("Content-Type", "application/json");
    $team = $app->request()->post('team');
    $website = $app->request()->post('websiteid');  //echo 'Munei '.$poshto;
    $module = $app->request()->post('module');
    $row1 = $db->website_info()->where("site", $website)->where("team", $team)->where("module", $module);
    if ($s1 = $row1->fetch()) {

        $response = array('success' => 1, 'message' => $s1['display_position']);
        echo json_encode($response);
    }
});

$app->post('/change_module_display_order', function () use ($app, $db) {
    $app->response()->header("Content-Type", "application/json");
    $team = $app->request()->post('team');
    $website = $app->request()->post('websiteid');  //echo 'Munei '.$poshto;
    $module = $app->request()->post('module');
    $tikuisapapi = $app->request()->post('tikuisapapi');
    $poshto = $tikuisapapi;
    $row1 = $db->website_info()->where("site", $website)->where("team", $team)->where("module", $module);
    if ($s1 = $row1->fetch()) {
        //echo 'Step 2';

        $data = array(
            'display_position' => $poshto,
        );
        $result = $s1->update($data);

        if ($result == 1) {
            $message = "Successfully changed display order ";
        } else {
            $message = "Did not update display order. Likely there is no change from the last one";
        }
        $response = array('success' => $result, 'message' => $message);
        echo json_encode($response);
    }
});

$app->post('/get_templates', function () use ($app, $db) {
    $app->response()->header("Content-Type", "application/json");
    $templates = array();
    $help = array();
    $row1 = $db->website_templates()->where("active", 1);

    foreach ($row1 as $response) {

        //Lets find the faces that have got to do with it and save it here. 
        $row2 = $db->websites_template_facelets()->where("template", trim($response['template']));

        $help = array();
        foreach ($row2 as $temfo) {
            $info1 = array("module" => $temfo['module']
                , "description" => $temfo['description']);
            array_push($help, $info1);
        }
        $info = array("template" => trim($response['template'])
            , "description" => $response['description']
            , "link" => $response['link']
            , "help" => $help,
        );

        array_push($templates, $info);
    }
    echo json_encode($templates);
});



$app->post('/html_test', function () use ($app, $db) {
    $htmlcode = '<section class="mbr-gallery mbr-slider-carousel cid-s31wiA0V76" id="gallery1-8">
   <div>
      <div>
         <!-- Filter -->                      
         <div class="mbr-gallery-filter container gallery-filter-active">
            <ul buttons="0">
               <li class="mbr-gallery-filter-all">                    <a class="btn btn-md btn-primary-outline active display-7" href="">All</a>                 </li>
            </ul>
         </div>
         <!-- Gallery -->                      
         <div class="mbr-gallery-row">
            <div class="mbr-gallery-layout-default">
               <div>
                  <div id="facelets">
                     <div id="1596714853384" class="mbr-gallery-item mbr-gallery-item--p2" data-video-url="false" data-tags="fed">
                        <div href="#lb-gallery1-8" data-slide-to="cl15968842507860" data-toggle="modal"><img src="https://cresterp.com/api/uploads/uploads/5683458299943211157.png" alt="" 			                          		title=""><span class="icon-focus"></span><span class="mbr-gallery-title mbr-fonts-style display-7">        				ded</span>        			</div>
                     </div>
                     <div id="15967148533434384" class="mbr-gallery-item mbr-gallery-item--p2" data-video-url="false" data-tags="gango">
                        <div href="#lb-gallery1-8" data-slide-to="cl15968842507861" data-toggle="modal"><img src="https://cresterp.com/api/uploads/uploads/AP1596624072126-temp6899673558944903305..jpg" alt="" 					title=""><span class="icon-focus"></span><span class="mbr-gallery-title mbr-fonts-style display-7">                             mbaone</span>                          </div>
                     </div>
                     <div id="1596884250786" class="mbr-gallery-item mbr-gallery-item--p2" data-video-url="false" data-tags="zvinhu">
                        <div href="#lb-gallery1-8" data-slide-to="cl15968842507862" data-toggle="modal"><img src="https://cresterp.com/api/uploads/uploads/AP1596624072126-temp1891946955716568975..jpg" alt="" 					title=""><span class="icon-focus"></span><span class="mbr-gallery-title mbr-fonts-style display-7">
                           zvinhu</span>
                        </div>
                     </div>
                  </div>
               </div>
               <div class="clearfix"></div>
            </div>
         </div>
         <!-- Lightbox -->           <!-- Lightbox -->                      
         <div data-app-prevent-settings="" class="mbr-slider modal fade carousel slide" tabindex="-1" data-keyboard="true" data-interval="false" id="lb-gallery1-8">
            <div class="modal-dialog">
               <div class="modal-content">
                  <div class="modal-body">
                     <ol id="light_box_count" class="carousel-indicators">
                        <li id="cl1596714853384" data-app-prevent-settings="" data-target="#lb-gallery1-8" class="active" data-slide-to="cl15968842507860"></li>
                        <li id="cl15967148533434384" data-app-prevent-settings="" data-target="#lb-gallery1-8"  data-slide-to="1cl1596884250786"></li>
                        <li id="cl1596884250786" data-app-prevent-settings="" data-target="#lb-gallery1-8"  data-slide-to="cl1596884250786"></li>
                     </ol>
                     <div id="light_box_images" class="carousel-inner">
                        <div id="fl1596714853384" class="carousel-item active"><img src="https://cresterp.com/api/uploads/uploads/5683458299943211157.png" alt="" title=""></div>
                        <div id="fl15967148533434384" class="carousel-item"><img src="https://cresterp.com/api/uploads/uploads/AP1596624072126-temp6899673558944903305..jpg" alt="" title=""></div>
                        <div id="fl1596884250786" class="carousel-item"><img src="https://cresterp.com/api/uploads/uploads/AP1596624072126-temp1891946955716568975..jpg" alt="" title=""></div>
                     </div>
                     <a class="carousel-control carousel-control-prev" role="button" data-slide="prev" href="#lb-gallery1-8">                       <span class="mbri-left mbr-iconfont" aria-hidden="true"></span>                       <span class="sr-only">Previous</span>                       </a>                       <a class="carousel-control carousel-control-next" role="button" data-slide="next" href="#lb-gallery1-8">                       <span class="mbri-right mbr-iconfont" aria-hidden="true"></span>                       <span class="sr-only">Next</span>                       </a>                       <a class="close" href="#" role="button" data-dismiss="modal">                       <span class="sr-only">Close</span>                       </a>                                        
                  </div>
               </div>
            </div>
         </div>
      </div>
   </div>
</section>';
    $team = process_position_numbers($htmlcode);
    //		echo $team ;
});

function getDomain($url) {
    $pieces = parse_url($url);
    $domain = isset($pieces['host']) ? $pieces['host'] : '';
    if (preg_match('/(?P<domain>[a-z0-9][a-z0-9\-]{1,63}\.[a-z\.]{2,6})$/i', $domain, $regs)) {
        return $regs['domain'];
    }
    return FALSE;
}

$app->post('/preview_website', function () use ($app, $db) {
    $app->response()->header("Content-Type", "application/json");

    $team = $app->request()->post('team');
    $id = $app->request()->post('websiteid');

    $row = $db->websites()->where("website_app_id", $id)->where("team", $team);
    //	echo $row;
    $weblink = "";
    if ($data = $row->fetch()) {
        $weblink = $data['domain'];
    }
    $array = array('domain' => $weblink);
    echo json_encode($array);
});

function randomString($length) {
    $str = "";
    $characters = array_merge(range('A', 'Z'), range('a', 'z'), range('0', '9'));
    $max = count($characters) - 1;
    for ($i = 0; $i < $length; $i++) {
        $rand = mt_rand(0, $max);
        $str .= $characters[$rand];
    }
    return $str;
}

$app->get('/retrieve_website_data', function () use ($app, $db) {
    $app->response()->header("Content-Type", "application/json");

    $website = array(
        //			'header' => "Nothing",
        //			'info'      => "Nothing", 	
        'htmltemplate' => "Website under construction",
            //			'sqldata'          => "nosql",
    );



    $link = $app->request()->get('link');
    $domainname = getDomain($link);
    $row = $db->websites()->where("domain", $link);
    $r = $row;
    $html_content = "";
    $botenabled = "";



    if ($siteinfo = $row->fetch()) {
        $website['header'] = $siteinfo;
        $sitemetatags = $siteinfo['siteheadermeta'];
        $sitescripts = $siteinfo['siteheaderscripts'];

        $botenabled = $siteinfo['botenabled'];
        //Lets find information related with the site;
        $info = array();
        $row1 = $db->website_info()->where("site", $siteinfo['website_app_id'])->where("team", $siteinfo['team'])->where("deleted", 0)->order("display_position ASC");
        $r1 = $row1;

        foreach ($row1 as $response) {
            array_push($info, $response);
            $html_content = $html_content . $response['facelet_html'];
        }
        $website['info'] = $info;

        //Lets find the template string here 
        $rowt = $db->website_templates()->where("template", $siteinfo['template']);
        $rt = $rowt;

        if ($template = $rowt->fetch()) {

            $str = $template['htmlinfo'];
            $visitorid = time() . randomString(10);
            // $visitorid = "visitor";
            $md5 = md5($visitorid);
            $bot = ' 
<section id="gmessenger" class="avenue-messenger">
  <div class="menu">
    <!--<div class="items"><span>
     <a href="#" title="Minimize">&mdash;</a><br>
     <a href="#" onclick="minimize();" title="End Chat">&#10005;</a> 
    <button onclick="myFunction()">Click me</button>
     
     </span></div>-->
    <div class="button" onclick="minimize();" >  &#10005;  </div>
    
  </div>
  <div class="agent-face">
    <div class="half">
     <img class="agent circle" src="https://cresterp.com/api/uploads/uploads/bot1.png" alt="Jesse Tino"></div>
  </div>
<div class="chat">
  <div class="chat-title">
    <!--<h1>Jesse Tino</h1>
    <h2>RE/MAX</h2>-->
    <p> Welcome to ' . $domainname . '</p>
  <!--  <figure class="avatar">
      <img src="https://askavenue.com/img/17.jpg" /></figure>-->
  </div>
  <div class="messages">
    <div class="messages-content"></div>
  </div>
  <div class="message-box">
    <textarea type="text" class="message-input" placeholder="Type message..."></textarea>
    <button type="submit" class="message-submit">Send</button>
  </div>
  </div><input type="hidden" id="visitorid" name="visitorid" value="' . $md5 . '">
        <input type="hidden" id="host" name="host" value="' . $domainname . '">
<!--<div class="bg"></div>--> </section>

<div style="font-size: 24px;" onclick="minimize();">
<a id="fab" href="#" class="float"> 
<!--<i class="fa fa-intercom my-float"></i>
<i class="fas fa-comment-dots my-float"></i>-->
<!--<i class="fa fa-plus my-float"></i>-->
<i class="fa fa-comments-o fa-lg my-float"></i>
</a></div>
<!--<div class="label-container" onclick="minimize();">
<div class="label-text">I am Gina, virtual Assistant</div>
<i class="fa fa-play label-arrow"></i>
</div>-->
';




            if ($botenabled) {

                //$html_content = $html_content . $bot;

                $str = str_replace("ASSITANTCODE", $bot, $str);
            } else
                $html_content = $html_content;

            $str = str_replace("SITE_META_HEADER", $sitemetatags, $str);

            $str = str_replace("SITE_HEADER_SCRIPTS", $sitescripts, $str);

            $str = str_replace("BODYCODE", $html_content, $str);
            $str = str_replace("ASSITANTCODE", "", $str);

            // $str = str_replace("CUSTOM_STYLE", $botcss, $str);

            $website['htmltemplate'] = urlencode($str);
            //Here we must look for the modules related to this site and replace them with the body tag 
        }
    }
    //		 	  $arr = array ('sql1' => $r, 'sql2' => $r1, 'sql3' => $rt);
    //echo 'Before assignment: '; var_dump ($website);
    //	  $website['sqldata'] = $arr;
    //	var_dump ($website);

    echo json_encode($website);
});

$app->post('/app_account_code', function () use ($app, $db) {
    $app->response()->header("Content-Type", "application/json");
    $source = $app->request()->post('source');
    $message = md5($source);
    $success = 1;
    $response = array('success' => $success, 'message' => $message);
    //Lets open an account in Gap365 that can be verified against later on. 
    $data = array(
        'Fuid' => $message,
    );
    $db->Users()->insert($data);
    echo json_encode($response);
});



$app->post('/modify_gallery_video', function () use ($app, $db) {
    $app->response()->header("Content-Type", "application/json");
    $team = $app->request()->post('team');
    $id = $app->request()->post('websiteid');
    $foreignid = $app->request()->post('foreignid');
    //$moduleinfo = json_decode ($app->request()->post('moduleinfo'));
    $website = $id;
    //	$foreignid = $moduleinfo ->foreignid;
    $response = array();
    $row1 = $db->website_info()->where("site", $website)->where("team", $team)->where("module", "GALLERY_VIDEO");
    if ($siteinfo = $row1->fetch()) {
        $htmlcode = $siteinfo['facelet_html'];
        $dbmoduleinfo = json_decode($siteinfo['module_data']);
        $image = $dbmoduleinfo->path;
        $processed = delete_image_gallery($htmlcode, $foreignid, $image);

        $data = array(
            'facelet_html' => $processed,
        );

        $result = $row1->update($data);
        //echo $processed;
    }
    $success = 1;
    $message = "Successfully deleted the video";
    $response = array('success' => $success, 'message' => $message);
    echo json_encode($response);
});



$app->post('/modify_gallery_item', function () use ($app, $db) {
    $app->response()->header("Content-Type", "application/json");
    $team = $app->request()->post('team');
    $id = $app->request()->post('websiteid');
    $foreignid = $app->request()->post('foreignid');
    //$moduleinfo = json_decode ($app->request()->post('moduleinfo'));
    $website = $id;
    //	$foreignid = $moduleinfo ->foreignid;
    $response = array();
    $row1 = $db->website_info()->where("site", $website)->where("team", $team)->where("module", "GALLERY_IMAGE")->where("deleted", 0);
    if ($siteinfo = $row1->fetch()) {
        $htmlcode = $siteinfo['facelet_html'];
        $dbmoduleinfo = json_decode($siteinfo['module_data']);
        $image = $dbmoduleinfo->path;
        $processed = delete_image_gallery($htmlcode, $foreignid, $image);

        $data = array(
            'facelet_html' => $processed,
        );

        $result = $row1->update($data);
        //echo $processed;
    }
    $success = 1;
    $message = "Successfully deleted the image";
    $response = array('success' => $success, 'message' => $message);
    echo json_encode($response);
});



$app->post('/upload_module', function() use( $app, $db ) {
    $app->response()->header("Content-Type", "application/json");

    $team = $app->request()->post('team');
    $id = $app->request()->post('websiteid');
    $module = $app->request()->post('module');
    $moduleinfo = urldecode($app->request()->post('moduleinfo'));
    $website = $id;
    $response = array();
    //var_dump ($app->request()->post()); exit (0);
    // echo 'Tichanfosvika pafunction website: '.$website.' module: '.$module.' module info: '.$moduleinfo;
    //Check if the website exists if not we are creating a new module
    if (checkIfWebsiteExists($app, $db, $id, $team)) {

        //Lets update it 
        $siteExists = true;
        $response = updateWebsite($app, $db, $team, $website, $module, $moduleinfo, $siteExists);
    } else {

        //We must check if they have paid for the website if yes then create the information. 
        $siteExists = false;
        $response = updateWebsite($app, $db, $team, $website, $module, $moduleinfo, $siteExists);
    }

    echo json_encode($response);
});

function updateWebsite($app, $db, $team, $website, $module, $moduleinfo, $siteExists) {

    // echo 'website: '.$website.' module: '.$module.' module info: '.$moduleinfo;
    $success = 0;
    $message = "Could not process request";

    /* $template = json_decode ($moduleinfo);
      $selected = $template->template;
      $selected = trim ($selected); */


    /* if (!$siteExists){
      //$array = array('success' => $success, 'message' => $message);
      //secho  json_encode($array); exit (0);

      $str = time();
      $domain = md5($str);
      $domain = 'https://sites.gap365.co/'.$domain;

      $data = array(
      'website_app_id' => $website,
      'team'                => $team,
      'domain'	          => $domain,
      );
      //Lets save to the database here
      $db->websites->insert($data);
      } */

    //Next lets process the information for each of the modules. 
    if ($module === "BASIC_INFO") {
        //	echo 'Tapinda mukati meBasic info';

        $result = checkIfWebsiteModuleExists($app, $db, $website, $team, $module);
        if (empty($result)) {
            //save module    	
            save_module_info($app, $db, $website, $team, $moduleinfo, $module);
        } else {
            //update module    
            update_module_info($app, $db, $website, $team, $result, $moduleinfo, $module);
            //($app,$db,$result,$moduleinfo,$website); 		 		
        }
        $success = 1;
        $message = "Basic info successfully published";
    }

    //  	echo 'before mulanding module ine: '.$module;
    if ($module === "LANDING_INFO") {

        //	echo 'tapinda mulanding macho';

        $result = checkIfWebsiteModuleExists($app, $db, $website, $team, $module);
        if (empty($result)) {
            //save module   
            //	echo 'Inside empty module which is to save:  '.$result;
            save_module_landing_info($app, $db, $website, $team, $moduleinfo, $module);
        } else {
            //update module    
            update_module_landing_info($app, $db, $result, $moduleinfo, $website, $team, $module);
        }
        $success = 1;
        $message = "Landing info successfully published";
    }


    if ($module === "VALUE_PROPOSITION") {

        $result = checkIfWebsiteModuleExists($app, $db, $website, $team, $module);
        if (empty($result)) {
            //save module   
            //	echo 'Inside empty module which is to save:  '.$result;
            save_module_value_proposition($app, $db, $website, $team, $moduleinfo, $module);
        } else {
            //update module    
            update_module_value_proposition($app, $db, $result, $moduleinfo, $website, $team, $module);
        }
        $success = 1;
        $message = "Value proposition successfully published";
    }

    if ($module === "ACHIEVEMENTS") {

        $result = checkIfWebsiteModuleExists($app, $db, $website, $team, $module);
        if (empty($result)) {
            //save module   
            //	echo 'Inside empty module which is to save:  '.$result;
            save_module_achievements($app, $db, $website, $team, $moduleinfo, $module);
        } else {
            //update module    
            update_module_achievements($app, $db, $result, $moduleinfo, $website, $team, $module);
        }
        $success = 1;
        $message = "Achievements successfully saved";
    }

    if ($module === "GALLERY_IMAGE") {

        $result = checkIfWebsiteModuleExists($app, $db, $website, $team, $module);
        if (empty($result)) {
            //save module   
            save_module_gallery_image($app, $db, $website, $team, $moduleinfo, $module);
            $success = 1;
            $message = "Product Image Gallery Saved Successfully";
        } else {
            //update module    
            update_module_image_gallery_facelet($app, $db, $result, $moduleinfo, $website, $team, $module);
            $message = "Product Image Gallery Successfully updated";
            $success = 1;
            //	 update_module_gallery_image ($app,$db,$result,$moduleinfo,$website,$team,$module);
        }
    }


    if ($module === "GALLERY_VIDEO") {

        $result = checkIfWebsiteModuleExists($app, $db, $website, $team, $module);

        if (empty($result)) {
            //save module   
            save_module_gallery_video($app, $db, $website, $team, $moduleinfo, $module);
            $success = 1;
            $message = "Product Video Gallery Saved Successfully";
        } else {
            //update module    
            update_module_video_gallery_facelet($app, $db, $result, $moduleinfo, $website, $team, $module);
            $message = "Product Video Gallery Successfully updated";
            $success = 1;
        }
    }



    if ($module === "PRODUCT_HIGHLIGHT") {

        $result = checkIfWebsiteModuleExists($app, $db, $website, $team, $module);
        if (empty($result)) {
            //save module   
            //	echo 'Inside empty module which is to save:  '.$result;
            save_module_product_highlight($app, $db, $website, $team, $moduleinfo, $module);
        } else {
            //update module    

            update_module_product_highlight($app, $db, $result, $moduleinfo, $website, $team, $module);
        }
        $success = 1;
        $message = "Product Highlight published Successfully";
    }


    $array = array('success' => $success, 'message' => $message);
    return $array;
}

$app->post('/upload_shop_product', function() use( $app, $db ) {
    $app->response()->header("Content-Type", "application/json");
    $date = date("Y-m-d");
    $hasAccount = false;
    $team = $app->request()->post('team');
    echo $team;
});

function save_module_info($app, $db, $website, $team, $moduleinfo, $module) {

    $htmlcode = process_basic_info_html($app, $db, $website, $team, $moduleinfo, $module);
    $template = json_decode($moduleinfo);
    $selected = $template->template;
    $selected = trim($selected);

    //Must update the website settings for the template. 
    $row1 = $db->websites()->where("website_app_id", $website)->where("team", $team);
    if ($row1->fetch()) {
        $data1 = array(
            'template' => $selected,
        );
        if ($selected != "customtemplate")
            $result = $row1->update($data1);
    }

    $data = array(
        'site' => $website,
        'team' => $team,
        'module' => $module,
        'module_data' => $moduleinfo,
        'facelet_html' => $htmlcode,
    );
    //Lets save to the database here 
    $db->website_info->insert($data);
    save_module_contact_info($app, $db, $website, $team, $moduleinfo, "CONTACT_INFO");
    //We must get the contact info as well and process it here. 
}

function update_module_info($app, $db, $website, $team, $moduleid, $moduleinfo, $module) {

    $htmlcode = process_basic_info_html($app, $db, $website, $team, $moduleinfo, $module);
    $template = json_decode($moduleinfo);
    $selected = $template->template;
    $selected = trim($selected);

    //Must update the website settings for the template. 
    $row1 = $db->websites()->where("website_app_id", $website)->where("team", $team);
    if ($row1->fetch()) {
        $data1 = array(
            'template' => $selected,
        );
        if ($selected != "customtemplate")
            $result = $row1->update($data1);
    }


    $data = array(
        'module_data' => $moduleinfo,
        'facelet_html' => $htmlcode,
    );
    $row = $db->website_info()->where("id", $moduleid);

    if ($row->fetch()) {
        $result = $row->update($data);

        $result1 = checkIfWebsiteModuleExists($app, $db, $website, $team, "CONTACT_INFO");
//				  					echo "Result i: ".$result1;

        if ($result1 > 0) {
            //		echo 'ID   found';
            update_module_contact_info($app, $db, $website, $team, $result1, $moduleinfo, "CONTACT_INFO");
        } else {
            //	echo 'ID haina kuitwa  found';
            save_module_contact_info($app, $db, $website, $team, $moduleinfo, "CONTACT_INFO");
        }
    }
}

function checkWebsiteHasBeenPaid($app, $db, $id, $team) {
    $exists = false;
    $row = $db->websites()->where("website_app_id", $id)->where("team", $team);
    if ($row->fetch()) {
        $exists = true;
    }

    return $exists;
}

function checkIfWebsiteModuleExists($app, $db, $id, $team, $module) {
    $result = "";
    $row = $db->website_info()->where("site", $id)->where("team", $team)->where('module', $module);
    //echo $row;
    if ($mod = $row->fetch()) {

        $result = $mod['id'];
    }

    //var_dump ($result);
    //	echo 'module id is: '.$result ;

    return $result;
}

function checkIfWebsiteExists($app, $db, $id, $team) {
    $exists = false;
    $id = trim($id);
    $row = $db->websites()->where("website_app_id", $id)->where("team", $team);
    if ($row->fetch()) {
        $exists = true;
    }

    return $exists;
}

//  $app->post('/upload_image', 'uploadFile');