<?php

$app->post('/get_prospects_starting/:start/:token', function($start, $token) use( $app, $db ) {

    $app->response()->header("Content-Type", "application/json");
    $data = array();
    $data = $db->prospects()->where("TEAM", $token)->where("APPDOWNLOADED", 0);
    echo json_encode($data);
});

$app->post('/get_affiliate_contact/:affiliateid', function($affiliateid) use( $app, $db ) {

    $app->response()->header("Content-Type", "application/json");

    $data = $db->Users()->select("Femail,SMSNumber")->where("Fuid", $affiliateid);
    echo json_encode($data);
});



$app->post('/record_prospect/:affiliateid', function($affiliateid) use( $app, $db ) {

    $app->response()->header("Content-Type", "application/json");

    $mobile = $app->request()->post('mobile');
    $message = $app->request()->post('message');
    $name = $app->request()->post('name');

    $date = date('Y-m-d');
    $data = array(
        'TEAM' => $affiliateid,
        'MOBILE' => $mobile,
        'CREATEDDATE' => $date,
        'MESSAGE' => $message,
        'MESSAGETYPE' => 'PROSPECT',
        'NAME' => $name,
    );


    $resulte = $db->prospects->insert($data);

    $response = array('success' => $success, 'message' => $message);
    echo json_encode($response);
});


$app->post('/get_customers_looking', function() use( $app, $db ) {
    //  $app->response()->header("Content-Type", "application/json");
    $date = date("Y-m-d");
    $hasAccount = false;
    $team = $app->request()->post('team');
    $lastId = $app->request()->post('lastid');
    $data = array();

    $account = $db->Users()->where("Fuid", $team)->where("accountexpires >= '" . $date . "'");
    //echo $account;

    foreach ($account as $subscriber) {

        $hasAccount = false;
        $subscribed = $subscriber['prospect_group'];
        //echo $subscribed;

        if (sizeof($subscribed) > 0) {
            $prospectgroups = explode(",", $subscribed);
            //	var_dump ($prospectgroups);
            foreach ($prospectgroups as $word) {

                $word = trim($word);
                $find = $db->botlog()->where("deleted", 0)->where("approveid > " . $lastId)->where("keyword_target LIKE '%" . $word . "%'")->where("active", 1)->where("expires >= '" . $date . "'");
                //	echo $find.';';
                foreach ($find as $item) {
                    //	echo $find ;
                    $hasAccount = true;
                    array_push($data, $item);
                }
            }
        }
    }
    // $data	 = $db->botlog()->where("customer_type","looking")->where("active",1)->where("expires >= '".$date."'"	);
    if ($hasAccount == false) {
        $find = $db->botlog()->where("deleted", 0)->where("approveid > " . $lastId)->where("active", 1)->where("expires >= '" . $date . "'");
        $length = sizeof($data) - 1;

        foreach ($find as $item) {

            $item['reductcontact'] = 1;
            array_push($data, $item);
        }
    }
    //  echo $data;

    echo json_encode($data);
});





$app->post('/update_prospects_download_status/:id/:token', function($id, $token) use( $app, $db ) {
    $app->response()->header("Content-Type", "application/json");
    $data = array();
    $data = array('APPDOWNLOADED' => 1);

    $row = $db->prospects()->where("id", $id);
    if ($row->fetch()) {
        if ($result = $row->update($data)) {
            echo json_encode(array('message' => 'Prospect updated successfully', 'success' => '1'));
        } else {
            echo json_encode(array('message' => 'Prospect update failed', 'success' => '0'));
        }
    }
});




