<?php

//Create Accounts here 

$app->post('/create_new_account', function () use ($app, $db) {

    $app->response()->header("Content-Type", "application/json");

    $mobile = $app->request()->post('mobile');
    $fullname = $app->request()->post('fullname');
    $address = $app->request()->post('address');
    $idnumber = $app->request()->post('idnumber');

    $data = array('fullname' => $fullname, 'idnumber' => $idnumber, 'mobilenumber' => $mobile,
        'address' => $address,);

    if ($id = $db->shumba_accounts->insert($data)) {

        echo json_encode(array('response' => 'Account successfully created', 'success' => '1', "account" => $id));
    } else {
        echo json_encode(array('response' => 'Failed to save Account', 'success' => '0'));
    }
});

$app->post('/get_transactions', function () use ($app, $db) {

    $app->response()->header("Content-Type", "application/json");
    $account = $app->request()->post('account');

    $rows = $db->shumba_transactions()->where("accountid", $account)->order("id DESC");
    $data = null;

    foreach ($rows as $row) {

        //$data[] = $row;
        $data = $data . " " . $row['datecreated'] . " # " . $row['type'] . " # " . $row['description'] . " @ ";
    }

    echo json_encode(array('account' => $account, 'transactions' => $data));
});


$app->post('/get_setting', function () use ($app, $db) {

    $app->response()->header("Content-Type", "application/json");
    $setting = $app->request()->post('setting');

    $rows = $db->shumba_settings()->where("settingname", $setting);
    
    foreach ($rows as $row) {
        $setting =  $row['details'];
    }

    // echo json_encode(array('response' => 'Balance request successful', 'success' => '1', 'account' => $idnumber, 'balance' => $balance));
    echo json_encode(array('success' => 1, 'details' => $setting));
});


$app->post('/get_account_balance', function () use ($app, $db) {

    $app->response()->header("Content-Type", "application/json");
    $idnumber = $app->request()->post('idnumber');

    $data = $db->shumba_accounts()->where("id", $idnumber);
    $balance = 0;
    foreach ($data as $row) {
        $balance = $row['balance'];
        $idnumber = $row['id'];
    }

    // echo json_encode(array('response' => 'Balance request successful', 'success' => '1', 'account' => $idnumber, 'balance' => $balance));
    echo json_encode(array('account' => $idnumber, 'balance' => $balance));
});

$app->post('/send_order', function () use ($app, $db) {

    $app->response()->header("Content-Type", "application/json");

    $topup = $app->request()->post('topup');
    $pop = $app->request()->post('pop');
    $sendername = $app->request()->post('sender');
    $name = $app->request()->post('name');
    $mobile = $app->request()->post('mobile');
    $ordernumber = $app->request()->post('ordernumber');
    $currency = $app->request()->post('currency');
    $rate = $app->request()->post('rate');
    $expecteddeposit = $app->request()->post('expecteddeposit');
    $account = $app->request()->post('account');
    $balance = $app->request()->post('balance');

    $data = array('sender' => $mobile, 'sendername' => "MOBILE_WALLET_ORDER " . $sendername, 'recipient' => $name,
        'ordernumber' => $ordernumber, 'expecteddeposit' => $expecteddeposit, 'rate' => $rate
        , 'amount' => $topup . " " . $currency, 'recipientmobile' => $mobile,
        'deposit' => $topup, 'orderstatus' => "APPROVED", 'pop' => $pop, 'currency' => $currency);

    $db->shumba_orders->insert($data);

    $row = $db->shumba_accounts()->where('id', $account);
    if ($result = $row->fetch()) {


        $data = array("balance" => $balance);

        if ($row->update($data)) {

            $txt = "MOBILE WALLET ORDER. Please note that " . $sendername . " has made an order of "
                    . $topup . " USD for collection by " . $name;
            //$txt = urlencode($txt);
            $res = notify_admin_group($txt);

            //Lets save the transaction here
            $data = array('accountid' => $account, 'orderid' => $ordernumber, 'type' => "MOBILE WALLET ORDER",
                'description' => 'Sent ' . $topup . ' ' . $currency . ' to ' . $name);

            $db->shumba_transactions->insert($data);

            echo json_encode(array('response' => 'Order sent successfully ', 'success' => '1'));
        }
    } else {

        echo json_encode(array('response' => ' Account not found ', 'success' => '0'));
    }
});

$app->post('/upload_deposit', function () use ($app, $db) {

    $app->response()->header("Content-Type", "application/json");

    $account = $app->request()->post('account');
    $topup = $app->request()->post('topup');
    $pop = $app->request()->post('pop');
    $name = $app->request()->post('name');
    $mobile = $app->request()->post('mobile');
    $ordernumber = $app->request()->post('ordernumber');
    $currency = $app->request()->post('currency');

    $data = array('account' => $account, 'amount' => $topup, 'pop' => $pop, 'currency' => $currency);

    if ($id = $db->shumba_wallet_deposit->insert($data)) {

        $ordernumber = $ordernumber . "." . $id;

        //Here we insert into the order table as well 

        $data = array('sender' => $mobile, 'sendername' => $name, 'recipient' => "MOBILE_WALLET_DEPOSIT",
            'ordernumber' => $ordernumber, 'expecteddeposit' => $topup . " " . $currency
            , 'amount' => $topup . " " . $currency, 'recipientmobile' => $mobile, 'depositmethod' => 'bank',
            'deposit' => $topup, 'orderstatus' => "DEPOSITED", 'pop' => $pop, 'currency' => $currency);

        $ids = $db->shumba_orders->insert($data);
        $txt = "MOBILE WALLET DEPOSIT. Please note that " . $name . " has made a wallet deposit of " . $topup . " " . $currency;
        notify_admin_group($txt);

        echo json_encode(array('response' => 'Deposit POP successfully uploaded', 'success' => '1', "account" => $id));
    } else {
        echo json_encode(array('response' => 'Failed to save upload POP', 'success' => '0'));
    }

//we need to send a message for a request to be verified 
});

$app->post('/create_new_account', function () use ($app, $db) {

    $app->response()->header("Content-Type", "application/json");

    $mobile = $app->request()->post('mobile');
    $fullname = $app->request()->post('fullname');
    $address = $app->request()->post('address');
    $idnumber = $app->request()->post('idnumber');

    $data = array('fullname' => $fullname, 'idnumber' => $idnumber, 'mobilenumber' => $mobile,
        'address' => $address,);

    if ($id = $db->shumba_accounts->insert($data)) {

        echo json_encode(array('response' => 'Account successfully created', 'success' => '1', "account" => $id));
    } else {
        echo json_encode(array('response' => 'Failed to save Account', 'success' => '0'));
    }
});

//Deal with orders here 

$app->get('/get_all_orders/:id/:token', function ($id, $token) use ($app, $db) {
    $app->response()->header("Content-Type", "application/json");

//  $rows = $db->shumba_orders()->where("open", true)->order("id desc");
    $rows = $db->shumba_orders()->order("id desc");
    echo json_encode(array('response' => $rows, 'success' => '1'));
});

$app->get('/clean_up_orders', function () use ($app, $db) {
    $app->response()->header("Content-Type", "application/json");

    $rows = $db->shumba_rates()->where("open", 0)->where("orderstatus", "OPENED");
    foreach ($rows as $row) {

        $dateString = $row['detecreated'];

// Create DateTime objects for the given date and the current date and time
        $givenDate = new DateTime($dateString);
        $currentDate = new DateTime();

// Calculate the difference between the given date and the current date
        $diff = date_diff($givenDate, $currentDate);

// Get the total number of hours in the difference
        $totalHours = $diff->days * 24 + $diff->h;

// Check if the total number of hours is greater than 24
        if ($totalHours > 24) {
            echo "The given date is greater than 24 hours ago.";
        } else {
            echo "The given date is within the last 24 hours.";
        }
    }

    echo json_encode(array('response' => $rows, 'success' => '1'));
});

$app->get('/get_all_rates/:id/:token', function ($id, $token) use ($app, $db) {
    $app->response()->header("Content-Type", "application/json");

    $rows = $db->shumba_rates();
    echo json_encode(array('response' => $rows, 'success' => '1'));
});

$app->post('/create_order/:id/:token', function ($id, $token) use ($app, $db) {

    $app->response()->header("Content-Type", "application/json");

    $sender = $app->request()->post('sender');
    $sendername = $app->request()->post('sendername');
    $recipient = $app->request()->post('recipient');
    $ordernumber = $app->request()->post('ordernumber');
    $amount = $app->request()->post('amount');
    $expecteddeposit = $app->request()->post('expecteddeposit');
    $depositmethod = $app->request()->post('depositmethod');
    $rate = $app->request()->post('rate');
    $orderstatus = $app->request()->post('orderstatus');

    $data = array('sender' => $sender, 'sendername' => $sendername, 'recipient' => $recipient,
        'ordernumber' => $ordernumber, 'amount' => $amount, 'expecteddeposit' => $expecteddeposit,
        'rate' => $rate, 'orderstatus' => $orderstatus);

    if ($db->shumba_orders->insert($data)) {

        echo json_encode(array('message' => 'Order successfully created', 'success' => '1'));
    } else {
        echo json_encode(array('message' => 'Failed to save order', 'success' => '0'));
    }
});

$app->post('/upload_order_pop', function () use ($app, $db) {

    $app->response()->header("Content-Type", "application/json");
    $orderid = $app->request()->post('id');
    $pop = $app->request()->post('pop');

    $data = array('pop' => $pop, 'orderstatus' => "DEPOSITED");
    $row = $db->shumba_orders()->where('id', $id);

    if ($row->fetch()) {
        if ($result = $row->update($data)) {
            echo json_encode(array('response' => 'Order successfully updated', 'success' => '1'));
        } else {
            echo json_encode(array('response' => 'Failed to save request. Likely because it has been updated already or has expired', 'success' => '0'));
        }
    }
});

$app->post('/update_rates', function () use ($app, $db) {
    $app->response()->header("Content-Type", "application/json");

    $cash = $app->request()->post('cash');
    $bank = $app->request()->post('bank');

    $cashdata = array(
        'amount' => $cash
    );

    $bankdata = array(
        'amount' => $bank
    );

    $response = "";
    $row = $db->shumba_rates()->where('ratename', 'cash');
    if ($row->fetch()) {
        if ($result = $row->update($cashdata)) {
            $response = " Cash Succeeded ";
        } else {
            $response = " Cash Failed or has not changed";
        }
    }

    $row = $db->shumba_rates()->where('ratename', 'bank');
    if ($row->fetch()) {
        if ($result = $row->update($bankdata)) {
            $response = $response . " Bank  Succeeded ";
        } else {
            $response = $response . ", Bank Failed or has not changed ";
        }
    }

    echo json_encode(array('response' => $response, 'success' => '1'));
});

$app->post('/topup_account', function () use ($app, $db) {
    $app->response()->header("Content-Type", "application/json");

    $id = $app->request()->post('id');
    $currency = $app->request()->post('currency');
    $amount = $app->request()->post('amount');

    $row = $db->shumba_accounts()->where('id', $id);
    if ($result = $row->fetch()) {
        $final = $result['balance'] + $amount;

        $data = array("balance" => $final);

        if ($row->update($data)) {
            echo json_encode(array('response' => 'account deposit successful', 'success' => '1'));
        } else {

            echo json_encode(array('response' => 'Failed to load wallet balance ', 'success' => '1'));
        }
    } else {

        echo json_encode(array('response' => 'Account not found ' . $result . " " . $row, 'success' => '0'));
    }
});

$app->post('/update_order', function () use ($app, $db) {
    $app->response()->header("Content-Type", "application/json");

    $id = $app->request()->post('id');
    $type = $app->request()->post('accounttype');
    $account = $app->request()->post('account');
    $amount = $app->request()->post('amount');
    $orderstatus = $app->request()->post('orderstatus');
    $open = $app->request()->post('open');
    $ordernumber = $id;

    if ($orderstatus === "COLLECTED" || $orderstatus === "DECLINED") {
        $open = 0;

        $currentDate = date("Y-m-d");

        $data = array(
            'open' => $open, 'collectiondate' => $currentDate,
            'orderstatus' => $app->request()->post('orderstatus'),
        );
    } else {


        $data = array(
            'open' => $open,
            'orderstatus' => $app->request()->post('orderstatus'),
        );
    }


    $row = $db->shumba_orders()->where('id', $id);
    if ($result = $row->fetch()) {
        if ($row->update($data)) {
            if (!empty($result['referredby'])) {
                $message = "Please note that your referral " . $result['sender'] . " has made a deposit of " . $result['amount'];
//send_whatsappmessage($result['referredby'], $message);
                $data = array("number" => $result['referredby'], "message" => $message);
                $db->message_dumps->insert($data);
            }

            if ($orderstatus === "APPROVED" && $type === "MOBILE_WALLET_DEPOSIT") {
                $row = $db->shumba_accounts()->where('id', $account);
                if ($result = $row->fetch()) {
                    $final = $result['balance'] + $amount;

                    $data = array("balance" => $final);

                    if ($row->update($data)) {
                        //Lets save the transaction here

                        $currency = "ZAR";
                        $data = array('accountid' => $account, 'orderid' => $ordernumber, 'type' => "MOBILE WALLET DEPOSIT",
                            'description' => 'Deposited ' . $amount . ' ' . $currency);

                        $rs = $db->shumba_transactions->insert($data);

                        echo json_encode(array('response' => 'account deposit successful ', 'success' => '1'));
                    } else {

                        echo json_encode(array('response' => 'Failed to load wallet balance ', 'success' => '1'));
                    }
                } else {

                    echo json_encode(array('response' => 'Account not found ', 'success' => '0'));
                }
            } else {
                echo json_encode(array('response' => 'order status change successful', 'success' => '1'));
            }
        } else {
            echo json_encode(array('response' => 'Failed to save request. Likely because it has been updated already ', 'success' => '0'));
        }
    }
});

function send_whatsappmessage($mobile, $message) {


    $curl = curl_init();

// Set the URL
    $url = 'https://katubu.com/api/hooks/communications/send_whatsapp';

    $mobile = str_replace(' ', '', $mobile);
    $mobile = ltrim($mobile, '0');

    if (!empty($mobile) && $mobile[0] !== '+') {
        $mobile = '+' . $mobile;
    }

// Set the POST data
    $data = array(
        'mobile' => $mobile,
        'message' => $message
    );

// Set cURL options
    curl_setopt($curl, CURLOPT_URL, $url);
    curl_setopt($curl, CURLOPT_POST, true);
    curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);

// Execute the cURL request
    $response = curl_exec($curl);

// Check for errors
    if ($response === false) {
        $error = curl_error($curl);
// Handle the error
    } else {
        
    }

// Close cURL
    curl_close($curl);
}

function notify_admin_group($message) {

    //ACTIONS ARE HANDLED HERE
    $token = "51699ca44339be3d894020d17f5a601cbb4cc7a8";

    $curl = curl_init();

    curl_setopt_array($curl, [
        CURLOPT_URL => "https://api.wassi.chat/v1/messages",
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => "",
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => "POST",
        CURLOPT_POSTFIELDS => "{\"group\":\"120363043710769547@g.us\",\"message\":\"" . $message . "\"}",
        CURLOPT_HTTPHEADER => [
            "Content-Type: application/json",
            "Token: 1488c551f8824bc3dbed6fe227613877e41de604bbc196e665d207c866d13810ae408be42f79d10c"
        ],
    ]);

    $responsecurl = curl_exec($curl);
    $err = curl_error($curl);

    curl_close($curl);

    $apiToken = "5558051869:AAFdqIr7g5GqBf7PEHCEa52G060MesWflwE";
    $message = $message;

    $channel = "-1001664324475";
    $entityBody = json_encode(file_get_contents('php://input'));
    $actual_link = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
//$message = "Place a ".$action." order on ".$symbol." Body: ".$entityBody." Link: ".$actual_link;


    $data = [
        'chat_id' => $channel,
        'text' => $message
    ];

    $res = file_get_contents("https://api.telegram.org/bot$apiToken/sendMessage?" . http_build_query($data));

    return $responsecurl . " error: " . $err;
}

$app->post('/send_whatsapp_shumba_admin', function () use ($app, $db) {

    $app->response()->header("Content-Type", "application/json");
// Initialize cURL
    $curl = curl_init();

// Set the URL
    $url = 'https://katubu.com/api/hooks/communications/send_whatsapp_shumba_admin_group';

    $message = $app->request()->post('message');

// Set the POST data
    $data = array(
        'message' => $message
    );

// Set cURL options
    curl_setopt($curl, CURLOPT_URL, $url);
    curl_setopt($curl, CURLOPT_POST, true);
    curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);

// Execute the cURL request
    $response = curl_exec($curl);

// Check for errors
    if ($response === false) {
        $error = curl_error($curl);
// Handle the error
    } else {
        
    }

// Close cURL
    curl_close($curl);
    echo json_encode(array('response' => 'message queued successfuly', 'success' => '1'));
});

$app->post('/send_whatsapp', function () use ($app, $db) {

    $app->response()->header("Content-Type", "application/json");
// Initialize cURL
    $curl = curl_init();

// Set the URL
    $url = 'https://katubu.com/api/hooks/communications/send_whatsapp';

    $mobile = $app->request()->post('mobile');
    $message = $app->request()->post('message');

    $mobile = str_replace(' ', '', $mobile);
    $mobile = ltrim($mobile, '0');

    if (!empty($mobile) && $mobile[0] !== '+') {
        $mobile = '+' . $mobile;
    }

// Set the POST data
    $data = array(
        'mobile' => $mobile,
        'message' => $message
    );

// Set cURL options
    curl_setopt($curl, CURLOPT_URL, $url);
    curl_setopt($curl, CURLOPT_POST, true);
    curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);

// Execute the cURL request
    $response = curl_exec($curl);

// Check for errors
    if ($response === false) {
        $error = curl_error($curl);
// Handle the error
    } else {
        
    }

// Close cURL
    curl_close($curl);
    echo json_encode(array('response' => 'message queued successfuly', 'success' => '1'));
});

//**********************BOILER TEMPLATE CODE NEEDS TO BE MODIFIED********************************************
$app->post('/add_device', function () use ($app, $db) {
    $app->response()->header("Content-Type", "application/json");

    $today = date("Y-m-d");
    $expires = date("Y-m-d", strtotime($today . "+7 days"));
    $data = array(
        'number' => $app->request()->post('mobile'),
        'message' => $app->request()->post('message'),
        'customer_type' => $app->request()->post('customertype'),
        'expires' => $expires,
        'active' => 0,
        'keyword_target' => $app->request()->post('keywordtarget'),
        'target_location' => $app->request()->post('targetlocation'),
        'team' => $app->request()->post('team'),
    );
    if ($db->botlog->insert($data)) {

        echo json_encode(array('message' => 'Request successfully uploaded', 'success' => '1'));
    } else {
        echo json_encode(array('message' => 'Failed to save request', 'success' => '0'));
    }
});

$app->get('/update_inbox/:id/:token', function ($id, $token) use ($app, $db) {
    $app->response()->header("Content-Type", "application/json");
    $data = array();
    $data = array('appdownloaded' => 1);

    $row = $db->app_communication()->where("id", $id);
    if ($row->fetch()) {
        if ($result = $row->update($data)) {
            echo json_encode(array('message' => 'Message updated successfully', 'success' => '1'));
        } else {
            echo json_encode(array('message' => 'Message update failed', 'success' => '0'));
        }
    }
});

$app->post('/get_app_update', function () use ($app, $db) {

    $app->response()->header("Content-Type", "application/json");
    /* $appversion  =  get_appversion($db);
      $updatelink    = "https://bit.ly/gapinstall";
      $version    = "Version2.01"; */
    $row = $db->app_communication()->where("message_type", "APPEXPIRES");
    foreach ($row as $response) {
        $appversion = $response['datecreated'];
        $time = strtotime($appversion);
        $appversion = date('Y-m-d', $time);
        $version = $response['message'];
        $updatelink = $response['updatelink'];
    }


    $data = array('appexpires' => $appversion, 'updatelink' => $updatelink, 'version' => $version);
    echo json_encode($data);
});

$app->post('/update_account_details/:token', function ($token) use ($app, $db) {
    $app->response()->header("Content-Type", "application/json");

    $data = array(
        'SMSNumber' => $app->request()->post('mobile'),
        'Femail' => $app->request()->post('email'),
        'Ffname' => $app->request()->post('name'),
        'SMSSender' => $app->request()->post('organisation'),
    );

    $result = $db->Users()->where("fuid", $token);
    $verdict = "Update Failed. Account not found";
    $status = 0;
    if ($row = $result->fetch()) {
        $row->update($data);
        $verdict = "Account successfully updated";
        $status = 1;
    }
    $data = array('success' => $status, 'message' => $verdict);
    echo json_encode($data);
});

$app->post('/verify_account/:token', function ($token) use ($app, $db) {

    $app->response()->header("Content-Type", "application/json");

    $word = "affiliate";
    $result = $db->Users()->where("fuid", $token)->where("prospect_group LIKE '%" . $word . "%'");
    $verdict = false;
    foreach ($result as $account) {
        $verdict = true;
    }
    $data = array('success' => 1, 'verified' => $verdict);
    echo json_encode($data);
});

function get_appversion($db) {

    $appversion = 0;
    $row = $db->app_communication()->where("message_type", "APPEXPIRES");
    foreach ($row as $response) {
        $appversion = $response['datecreated'];
        $time = strtotime($appversion);
        $appversion = date('Y-m-d', $time);
    }

//	 echo 'Version i '.	$appversion;
    return $appversion;
}

?>