<?php

require 'NotORM.php';
require 'dbconfig.php';
 
$json = file_get_contents('php://input');
$action = json_decode($json, true);
$constatus = walk_recursive($action,'save_it_status')[0];


 

//----------LET'S SAVE LOOKING FOR STUFF-----------------

if ($constatus == 'save_it' && $conname == 'looking_for_something'){
    
    $conname = walk_recursive($action,'conversation_name')[0];
$telegramid = walk_recursive($action,'telegram_id')[0];
$contact = walk_recursive ($action,'contact');
$fullname   = $contact[1]['name'];

    $looking = walk_recursive ($action,'looking_for_description')[0];
    $budget  = walk_recursive ($action,'looking_for_budget')[0];
    $currency  = walk_recursive ($action,'looking_for_currency_symbol')[0];
    $location  = walk_recursive ($action,'looking_for_location')[0];
    
 
       $data = array(
        'payload' =>  $json ,
        'channel' =>  'telegram',
        'userid'=>$telegramid,
        'fullname'=>$fullname,
        'request'=>$looking,
        'budget'=>$budget,
        'currency'=>$currency,
        'location'=>$location,
        'status'=>'UNAPPROVED',
    );
    
 
     $db->katubu_looking_for->insert($data);   
    
}

//-------------LETS SAVE BUSINESS HERE---------------- 
if ($constatus == 'BUSINESS_SIGNUP'){
  
    $userid = walk_recursive ($action,'userid')[0];
    $fullname  = walk_recursive ($action,'fullname')[0];
    $contact  = walk_recursive ($action,'contact')[0];
    $location  = walk_recursive ($action,'locations')[0];
    $services  = walk_recursive ($action,'services')[0]; 
    
    $data = array (
            'userid'     =>   $userid,
            'name'       =>   $fullname,
            'contact'    =>   $contact,
            'locations'  =>   $location,
            'services'   =>   $services,
        );
    
    //We need to check if it exists in the database else we enter it 
     $id = 0;
     $businesses  = $db->katubu_businesses()->where("userid", $userid);
     foreach ($businesses as $business){
         $id = $business['id'];
     }
    

         $row  = $db->katubu_businesses()->where("id", $id);
            if ($row->fetch()) {
                
                $result = $row->update($data);
                    echo json_encode(array('message' => 'Business Profile Successfully UPDATED', 'success' => '1'));
                
            }else {
                 
                      if ($db->katubu_businesses->insert($data)){
                         echo json_encode(array('message' => 'Business Profile Successfully Created', 'success' => '1'));
                             } else {
                                echo json_encode(array('message' => 'Failed to save Business Profile ', 'success' => '0'));
                            } 
                
                }
      
   
    
}

if ($constatus == 'REFERAL_CHECK'){
   $userid = walk_recursive ($action,'userid')[0];
   $confirmedid = "";
     $agents  = $db->katubu_agents()->where("shareid", $userid);
     
     foreach ($agents as $agent){
         $confirmedid = $agent['userid'];
     }
       echo json_encode(array('message' => $confirmedid, 'success' => '0'));
}

//-------------LETS SAVE BUSINESS CATEGORY HERE---------------- 
if ($constatus == 'BUSINESS_SUBSCRIPTION'){
  
    $userid = walk_recursive ($action,'userid')[0];
    $fullname  = walk_recursive ($action,'fullname')[0];
    $category  = walk_recursive ($action,'category')[0]; 
    
    $data = array (
            'userid'     =>   $userid,
            'fullname'       =>   $fullname,
            'category'    =>  $category,
    );
    
    //We need to check if it exists in the database else we enter it 
     $id = 0;
     $businesses  = $db->katubu_business_subscription()->where("userid", $userid)->where("category",$category);
     foreach ($businesses as $business){
         $id = $business['id'];
     }
    
     //---TO DO 
     //---Check if they have a business profile. If not create one you can add free credits
     
     if ($id == 0){
           if ($db->katubu_business_subscription->insert($data)){
               
                         echo json_encode(array('message' => 'Category Subscription Successfully Created', 'success' => '1'));
           }
     }else {
         
           echo json_encode(array('message' => 'You are already subscribed to this category', 'success' => '1'));
     }
    
    
   
    
}

//------------LETS GET SUBSCRIBED INQUIRIES HERE ---------

if ($constatus == 'BROWSE_INQUIRIES'){
  
    $userid = walk_recursive ($action,'userid')[0];
    
    //We need to check if it exists in the database else we enter it 
     $subscriptions  = $db->katubu_business_subscription()->where("userid", $userid);
     $result = "";
     
     foreach ($subscriptions as $subscription){
        
        $category = $subscription['category'];
        //Lets find the queries under these subcriptions 
        if ($category == "property"){
            $properties  = $db->katubu_looking_property()->where("status", "APPROVED");
            $count = 0;
            foreach ($properties as $property){
                $count = $count + 1;
                $budget =   number_format(($property['budget']), 2, '.', ',');
                $result = "\n\nP".$property['id'].' - '.$property['category']."\n".$property['description']." with a budget of ".$budget." ".strtoupper($property['currency'])." located in ".$property['locations'].$result;
            }
            if ($count > 0){
                $result = $category."(".$count.")\n".$result ;
            }
        }
        
     }
     
  if (empty($result)){$result = "No inquiries at the moment";}
  
   echo json_encode(array('query' => $result, 'success' => '1'));
    
}

//------------LETS GET INQUIRY CONTACT DETAILS HERE -------------

if ($constatus == 'GET_INQUIRY_CONTACT'){
  
    $queryid = walk_recursive ($action,'queryid')[0];
    $id = preg_replace("/[^0-9]/", "", $queryid );
    $result = "Contact for inquiry number: ".$queryid." not found "; 
    
    if (strncmp(strtoupper($queryid), "P", strlen("P")) === 0){ //Lets handle property here
    
         $properties  = $db->katubu_looking_property()->where("id", $id)->where("status", "APPROVED");;
            foreach ($properties as $property){ 
                $result = "P".$property['id'].' - '. $property['description']."\n Name: ".$property['fullname']."\n Whatsapp: ".$property['whatsapp'];
                
                //here we must deduct the credits according to the rules available 
                
            }
    }
    
    
  
   echo json_encode(array('query' => $result, 'success' => '1'));
    
}


//-------------LETS SAVE NEW TO DO TASK---------------- 

if ($constatus == 'TO_DO_NEW_TASK'){
  
//  if (!empty($expires)){
    $userid = walk_recursive ($action,'userid')[0];
    $title  = walk_recursive ($action,'title')[0];
    $description  = walk_recursive ($action,'description')[0]; 
    $expires  = walk_recursive ($action,'expires')[0];
   
    $timestamp = strtotime($expires); 
    $date =  date("Y-m-d h:i:sa",$timestamp) ;

    $data = array (
            'userid'     =>   $userid,
            'title'       =>   $title,
            'description'    =>  $description,
            'expires'       => $date,
    );
    
           if ($db->katubu_to_do->insert($data)){
               
                         echo json_encode(array('message' => 'New Task Successfully Created expiring '.$date, 'success' => '1'));
           }
             else {
                 
                   echo json_encode(array('message' => 'Failed to saved new Task ', 'success' => '1'));
             }
  /*}else {
        echo json_encode(array('message' => 'Failed to saved new Task please make sure the expiry date is not empty...try typing the date instead of using date selector. Create another Task', 'success' => '1'));
  }*/
  
}


//------------LETS VIEW PERSONAL TASKS-----------

if ($constatus == 'BROWSE_MY_TASKS'){
  
    $userid = walk_recursive ($action,'userid')[0];
    
    //We need to check if it exists in the database else we enter it 
     $tasks  = $db->katubu_to_do()->where("userid", $userid)->where("status","OPEN");
     $result = "";
     $total = 0;
     $missed = 0;
     $current = date ('Y-m-d');
     
     foreach ($tasks as $task){ 
         
            $expires = $task['expires'];
            
            if ($expires < $current ){
                
                $missed = $missed + 1;
                
            }
            $total = $total + 1;
            $result = "\n\n".$task['id'].' - '.$task['title']."\n".$task['description'].$result;
        
        }
        

     
  if (empty($result)){$result = "No Tasks at the moment";}
  else {
	    $missed = ($missed / $total)*100;  $missed = round($missed);
		$result = "You have ".$total." open task(s) and have missed ".$missed."% of the deadlines".$result;
		}
  
   echo json_encode(array('query' => $result, 'success' => '1'));
    
}



//------------LETS VIEW PERSONAL TASKS-----------

if ($constatus == 'CLOSE_SINGLE_TASK'){
  
    $userid = walk_recursive ($action,'userid')[0];
    $taskid = walk_recursive ($action,'queryid')[0];
     
    //We need to check if it exists in the database else we enter it 
     $tasks  = $db->katubu_to_do()->where("userid", $userid)->where("status","OPEN")->where("id",$taskid);
     $result = "";
     $found = false ;
     $data = array ('status' => "CLOSED",);
     
     foreach ($tasks as $task){ 
            
            $found = true ;
            $result = $task->update($data);
            
        
        }
        
     
  if ($found){
      
      $result = "Task successfully closed";
      
  }else 
  {
      $result =" Task update failed. Task not found ";
      
  }
  
   echo json_encode(array('query' => $result, 'success' => '1'));
    
}



//------------GET PROMOTION CATEGORIES-------------

if ($constatus == 'GET_PROMOTION_CATEGORIES'){
  
       $categories  = $db->	katubu_promotion_categories()->where("active", 1);
        $message = "";
     foreach ($categories as $task){ 
         $message = $message." ".$task['position'].". ".strtoupper($task['name'])." - ".$task['description'];
     }
      echo json_encode(array('message' => $message, 'success' => '1'));
}



//------------LETS SAVE A NEW PROMOTION-----------

if ($constatus == 'SAVE_NEW_PROMOTION'){
  
    $userid = walk_recursive ($action,'userid')[0];
    $description = walk_recursive ($action,'description')[0];
	$original_price = walk_recursive ($action,'original_price')[0];
	$promotion_price = walk_recursive ($action,'promotion_price')[0];
	$currency = walk_recursive ($action,'currency')[0];  
    $links = walk_recursive ($action,'links')[0]; 
    $category = walk_recursive ($action,'category')[0]; 

	$discount = ($promotion_price / $original_price)*100;
	$discount = 100 - $discount;
	$discount = round ($discount);
 
     $data = array ('status' => "REVIEW",
					'description' => $description,
					'userid' =>  $userid ,
					'links' =>  $links ,
					'currency' =>  $currency ,
					'original_price' =>  $original_price ,
					'promotion' =>  $promotion_price ,
					'discount' =>  $discount ,
					'category' =>  $category ,
					);
           if ($db-> katub_business_promotions->insert($data)){
               
                         echo json_encode(array('message' => 'Promotion with a '.$discount.'% discount successfully submitted for review', 'success' => '1'));
           }
             else {
                 
                   echo json_encode(array('message' => 'Failed to submit promotion', 'success' => '1'));
             }
}




 function walk_recursive($obj, $key) {
		$found = array();
	  if ( is_object($obj) ) {
		foreach ($obj as $property => $value) 
			if($property === $key) $found[] = $value;
			elseif (is_array($value) || is_object($value)) 
				$found = array_merge( $found,  $this->walk_recursive($value, $key) );

	  } elseif ( is_array($obj) ) {
		foreach ($obj as $keyar => $value) 
			if($keyar === $key) $found[] = $value;
				elseif (is_array($value) || is_object($value)) $found = array_merge( $found,  walk_recursive($value, $key) );
	  }
	  return $found;
	}
	
	