<?php

$app->post( '/register_program', function() use( $app, $db ) {
    $app->response()->header("Content-Type", "application/json");
    $team = $app->request()->post('team');
    $id = $app->request()->post('program');
    $data = array('program' => $id, 'team' => $team);
    $message = "Program not found. Registration failed";
    $success = 0;
    
    //First find if the program actually exists. Then get the first day event and send it to the customer. 
    	$row1 = $db->programs()->where("code", $id); 
		if ( $s1 = $row1->fetch()) {   
				 	  
				 	  //Next find the first program item 
				 	  	 $row11 = $db->programs_breakdown()->where("code", $id)->order("daynumber ASC")->limit(1);
				 	  	 if ( $s11 = $row11->fetch()) {   
				 	  	 	 
				 	  		//Program exists and we register here 
					  $data = array ('program'=>$id, 'team'=>$team);
					  $programtheme = $s1 ['theme'];
					  //TODO If someone enrolled on the program. They should  not be added to the registration but everything else continues
					  $row111 = $db->program_registration()->where('program',$id)->where('team',$team);
					  $count = 0;
					  	 if ( $s111 = $row111->fetch()) {   
				 	 						 $count = $count + 1;
				 	  }else {
				 	  			 $db->program_registration->insert($data); 	
				 	  }
				 	  //Next lets insert into the prospect table the first course. 
				 	  $reference = $id.','.$s11['id'];
				 	  $prospectMessage =   $s11['description']; 
				 	   $data = array ('NAME'=>$programtheme, 'TEAM'=>$team, 'MESSAGE'=>$prospectMessage, 'MESSAGETYPE'=>"ANNOUNCEMENT",  'MESSAGEID'=>1,       
				 	   								'BROWSELINK' => $s11['contentlink'], 'REFERENCE'=>$reference, 'VIEWTYPE'=>'WEB',  'MESSAGEFORMAT'=>'JSON');  
				 	    $result  = $db->prospects->insert($data);
				 	 
				 	   
				     $message = "Successfully registered";
   				  $success = 1;  	
   				  
   				   }
					
		} 
    
    $response = array('success' => $success, 'message' => $message);
    echo json_encode( $response);
    
	  	
});


//Notify next day lesson.
$app->get( '/notify_next_day_training', function() use( $app, $db ) {
	
	  $students =  $db->program_registration()->where("completed",0);
	  foreach ($students as $student){
		  		//Find the last prospect entered
	  		  $student_program = $student['program'];
	  		  $team = $student['team']; // echo $team ;
	  		  $announcements	 = $db->prospects()->select("reference")->where("reference LIKE '%".$student_program."%'")
	  		  														->where('team',$team)->order('messageid desc')->limit(1);
	  		  //	echo $announcements;
	  		  $programs	 = $db->programs()->select("code","theme")->where("code",$student_program);
	  		  $progTitle = ""; 
	  		  	 if ( $p = $programs->fetch()) {  
	  		  	 		 $progTitle = $p['theme']; 
	  		  	 }
	  		 $title = ""; $prospectMessage=""; $reference="";
	  		  
	   
			 if ( $ann = $announcements->fetch()) { 
			 	//	echo $ann['reference'].'</br>';
		  		  	$pieces = explode(",", $ann['reference']);
		  		  //Select top here
		  			$breakdowns = $db->programs_breakdown()->where("code",$pieces[0])->where("id >".$pieces[1])->limit(1);
		  		//	echo '</br>'.$breakdowns;
		  			$messageid = 0;
		  				 if ( $break = $breakdowns->fetch()) {   
		  				 				//Add it to the prospects table.
		  				 				$title = 'Day '.$break['daynumber'].' - '.$progTitle;
		  				 				$prospectMessage = $break['description'];
		  				 				$reference = $pieces[0].','.$break['daynumber'];
		  				 				$messageid = $break['daynumber'];
		  				 				
		  			
		  					   $data = array ('NAME'=>$title, 'TEAM'=>$team, 'MESSAGE'=>$prospectMessage, 'MESSAGETYPE'=>"ANNOUNCEMENT", 'MESSAGEID'=>$messageid,
				 	   								'BROWSELINK' => $break['contentlink'], 'REFERENCE'=>$reference, 'VIEWTYPE'=>'WEB',  'MESSAGEFORMAT'=>'JSON');  
						    $result  = $db->prospects->insert($data);
	
					//	  var_dump ($data);
								  echo '</br>Adding '.$title.' for '.$team;
//								echo json_encode($data); 
	  		  }
	  				 }
	  		//		 echo '</br>Found student '.$team;
	  }

	
});

$app->post( '/get_programs', function() use( $app, $db ) {
	
    $app->response()->header("Content-Type", "application/json");
    $data = array();
    $data	 = $db->programs()->select("code","theme","description","durationdays")->where("active",1);
    echo json_encode( $data);
    
	  	
});
