<?php

use Slim\Factory\AppFactory;

require_once __DIR__ . '/../vendor/autoload.php';

$app = AppFactory::create();

// Parse json, form data and xml
$app->addBodyParsingMiddleware();

$app->addRoutingMiddleware();

$app->addErrorMiddleware(true, true, true);

// ...

$app->post('/', function (Request $request, Response $response, $args): Response {
    $data = $request->getParsedBody();
    
    $html = var_export($data, true);
    $response->getBody()->write($html);
    
    return $response;
});



$app->run();