<?php

//Let get the latest session details 

$session = getSession($number, $db);

//FIELD REPLACEMENTS FOR DYNAMIC RESPONSES 

if (str_contains($response, '{{subscriptions}}')) {

    $categoryId = $session['variable_s3'];
    $optionId = $session['variable_s5'];
    $category = null;
    $option = null;

    $categories = $db->katubu_stock_categories()->where('botname', $botname)->where("idnumber", $categoryId);
    foreach ($categories as $cat) {
        $category = $cat;

        $options = $db->katubu_stock_items()->where('botname', $botname)->where("position", $optionId)->where("category", $cat['id']);
        foreach ($options as $opt) {
            $option = $opt;
        }
    }



    if ($category != null && $option != null) {
        $txt = "Discipline: " . $category['description'] . " " . $option['items'] . "\nthat costs " . $option['price'] . " " . $option['currency'];

        //Lets add to the subscriptions table. 
        $title = trim($category['description']) . " (" . trim($option['items']) . ")";
        $data = array('subscriber' => $number, 'title' => $title, 'stock_item' => $option['id'],
            'amount' => $option['price'], 'currency' => $option['currency'], 'botname' => $botname);
        $s1 = $db->katubu_subscriptions->insert($data);
    }
    $response = str_replace("{{subscriptions}}", $txt, $response);
}

if (str_contains($response, '{{notify_customer_support}}')) {

    $customerteams = $db->katubu_bot_owners()->where("botname", $botname)->where("roles LIKE '%customers%'");
    $txt = ""; //$txt = $customerteams ;

    foreach ($customerteams as $member) {


        $text = "I am from " . $botname . ", you made an inquiry about '_*" . $session['variable_s1'] . "*_'";

        $link = generate_whatsapp_link($number, $text);
        $flight = "*CUSTOMER QUERY* \n\n Please note that the following client wants to talk to customer support \n\nINQUIRY: " . $session['variable_s1']
                . "\n\nTalk to them here\n\n" . $link;

        reply_message($member['number'], $flight, $messagetype);
    }
    $response = str_replace("{{notify_customer_support}}", $txt, $response);
}



if (str_contains($response, '{{notify_customer_teams}}')) {

    $customerteams = $db->katubu_bot_owners()->where("botname", $botname)->where("roles LIKE '%customer%'");
    $txt = ""; //$txt = $customerteams ;

    foreach ($customerteams as $member) {

        $subscriptions = $db->katubu_subscriptions()->where('botname', $botname)->where("subscriber", $number);
        $details = null;
        foreach ($subscriptions as $sub) {
            $details = $sub['title'];
        }
        $text = "I am from " . $botname . ", i understand you would like to make a payment for " . $details;

        $link = generate_whatsapp_link($number, $text);
        $flight = "*CUSTOMER REQUESTS* \n\n Please note that the following client wants to pay cash for a premium"
                . "\n\n" . $details . "\n\nTalk to them here\n\n" . $link;

        reply_message($member['number'], $flight, $messagetype);
    }
    $response = str_replace("{{notify_customer_teams}}", $txt, $response);
}

if (str_contains($response, '{{disciplines}}')) {

    $disciplines = $db->katubu_stock_categories()->where('botname', $botname)->order("idnumber DESC")->where("status", "ACTIVE");
    $txt = "";

    foreach ($disciplines as $discipline) {
        $txt = "\n*" . $discipline['idnumber'] . "*. " . $discipline['description'] . " " . $txt;
    }
    $response = str_replace("{{disciplines}}", $txt, $response);
}



if (str_contains($response, '{{quotation_details}}')) {

    $txt = "";
    //  $session = getSession($number, $db);
    $categorydescription = "";
    $catId = 0;
    $disciplines = $db->katubu_stock_categories()->where('botname', $botname)->where("idnumber", $session['variable_s3']);
    $txt = "";

    foreach ($disciplines as $discipline) {
        $categorydescription = $discipline['description'];
        $catId = $discipline['id'];
    }
    $options = $db->katubu_stock_items()->where('botname', $botname)->where("category", $catId)->where("position", $session['variable_s6']);
    $sql = $options;
    //$txt = " ".$sql ;
    // reply_message($botdevelopment, "Options: ".$sql, $messagetype);

    foreach ($options as $option) {

        $amount = number_format($option['cover'], 2, '.', ',');
        $price = number_format($option['price'], 2, '.', ',');
        $txt = "\n\n*" . trim($categorydescription)
                . "*" . display_quote($option['cover'], $option['price'], $option['position'], $option['currency']);
        //"* \n\nCover Limit: " . $amount . " " . $option['currency'] . "\n_*Pay: " . $price . "*_ " . $option['currency'] . $txt;
    }

    $data = array('nextconversationline' => 0, 'storesponse' => "", 'context' => "Confirm Quote");
    saveSession($number, $db, $data);
    $response = str_replace("{{quotation_details}}", $txt, $response);
}

if (str_contains($response, '{{payment_option_menu}}')) {

    $data = array(
        'storesponse' => 'variable_s6',
        'context' => "Payment Options",
    );
    saveSession($session['number'], $db, $data);
    $response = str_replace("{{payment_option_menu}}", "", $response);
}



if (str_contains($response, '{{premium_options}}')) {

    $txt = "";
    $stockId = 0;

    $subscriptions = $db->katubu_subscriptions()->where('botname', $botname)->where("subscriber", $number);
    foreach ($subscriptions as $sub) {
        $stockId = $sub['stock_item'];
    }


    $options = $db->katubu_stock_items()->where('botname', $botname)->where("id", $stockId);
    $sql = $options;

    foreach ($options as $option) {

        $amount = $option['cover'];
        $price = $option['price'];
        $currency = $option['currency'];
        $position = 0;

        $txt = display_premium_options($amount, $price, $position, $currency, $number, $db);
    }


    $response = str_replace("{{premium_options}}", $txt, $response);
}

function display_premium_options($cover, $annual, $position, $currency, $number, $db) {

    $stampduty = $GLOBALS['stampduty'];
    $annual = ($annual * $stampduty) + $annual;
    $amount = number_format($annual, 2, '.', ',');

    $biannual = $annual / 2;
    $biannual = ($biannual * $stampduty) + $biannual;
    $biannual = number_format($biannual, 2, '.', ',');

    $quarterly = $annual / 4;
    $quarterly = ($quarterly * $stampduty) + $quarterly;
    $quarterly = number_format($quarterly, 2, '.', ',');

    $txt = "\n_REQUIRED PREMIUM OPTIONS_ \n*1. Annual: " . $amount . " " . $currency . "*"
            . "\n*2. Biannual: " . $biannual . " " . $currency . "*"
            . "\n*3. Quarterly: " . $quarterly . " " . $currency . "*"
    ;

    $data = array('nextconversationline' => 0, 'storesponse' => "", 'context' => "Premium Menu",
        'variable_s1' => $amount, 'variable_s2' => $biannual, 'variable_s3' => $quarterly, 'variable_s5' => $currency);

    saveSession($number, $db, $data);

    return $txt;
}

function display_quote($cover, $annual, $position, $currency) {

    $stampduty = $GLOBALS['stampduty'];
    $annual = ($annual * $stampduty) + $annual;
    $amount = number_format($annual, 2, '.', ',');

    $biannual = $annual / 2;
    $biannual = ($biannual * $stampduty) + $biannual;
    $biannual = number_format($biannual, 2, '.', ',');

    $quarterly = $annual / 4;
    $quarterly = ($quarterly * $stampduty) + $quarterly;
    $quarterly = number_format($quarterly, 2, '.', ',');

    $txt = "\n\n*" . $position . ". Cover Limit: " . number_format($cover, 2, '.', ',') . " " . $currency
            . "*\n_REQUIRED PREMIUM OPTIONS_*\n_Annual: " . $amount . " " . $currency . "_"
            . "\n_Biannual: " . $biannual . " " . $currency . "_"
            . "\n_Quarterly: " . $quarterly . " " . $currency . "*_"
    ;
    return $txt;
}

if (str_contains($response, '{{discipline_options}}')) {

    $sql = "";
    $disciplines = $db->katubu_stock_categories()->where('botname', $botname)->where("idnumber", $session['variable_s3'])->order("idnumber DESC");
    $txt = "";

    foreach ($disciplines as $discipline) {

        $options = $db->katubu_stock_items()->where('botname', $botname)->where("category", $discipline['id'])->order("position DESC");
        $sql = $options;

        foreach ($options as $option) {

            $annual = $option['price'];
            $cover = $option['cover'];
            $txt = display_quote($cover, $annual, $option['position'], $option['currency']) . $txt;
        }
    }

    $response = str_replace("{{discipline_options}}", $txt, $response);
    //$response = $sql ;
}

if (str_contains($response, '{{reference}}')) {
    $response = str_replace("{{reference}}", $session['ordernumber'], $response);
}

if (str_contains($response, '{{depositmethod}}')) {
    $method = $session['variable_s5'];
    if ($method == 1) {
        $method = "bank";
    }
    if ($method == 2) {
        $method = "cash";
    }


    $response = str_replace("{{depositmethod}}", $method, $response);
}

function send_sms($mobile, $message) {



    $apiID = "API3349369761";
    $apipassword = "q8IkYjKQGtZBt5Y";
    $sms = urlencode($message);
    $senderid = "Credsure";

    $smsurl = 'https://rest.bluedotsms.com/api/SendSMS?api_id=' . $apiID . '&api_password=' . $apipassword
            . '&sms_type=P&encoding=T&sender_id=' . $senderid . '&phonenumber=' . $mobile . '&textmessage=' . $sms;
    $jsonData = json_decode(file_get_contents($smsurl));
}

if (str_contains($response, '{{process_upload_customer_db}}')) {

    if (!empty($filenamereceipt) || $filenamereceipt != null) {

        $file_ext = pathinfo($filenamereceipt, PATHINFO_EXTENSION);
        $ordernumber = $session['ordernumber'];
        $filenamereceipt = $ordernumber . "." . $file_ext;

        $imageurl = $fileslink . $filenamereceipt;
        $isdone = download_receipt($filenamereceipt, $fileurl, $deviceid, $filenamereceipt);
        if ($isdone) {

            $filename = 'receipts/' . $filenamereceipt;
            $file = fopen($filename, "r");
            $sample = "";
            $errors = "";

            while (!feof($file)) {
                $line = fgetcsv($file);
                $transactiondate = $line[0];
                //$transactiondate = str_replace("//", "-", $transactiondate);
                $time = strtotime($transactiondate);
                $transactiondate = date('Y-m-d', $time);

                $name = $line[1];
                $policynumber = $line[2];
                $policytype = $line[3];
                $policydescription = $line[4];
                $renewaldate = $line[5];
                // $renewaldate = str_replace("//", "-", $renewaldate);
                $time = strtotime($renewaldate);
                $renewaldate = date('Y-m-d', $time);

                $mobile = trim($line[6]);
                $mobile = str_replace(" ","", $mobile);
                
                $ogmobile = $mobile ;
                if (!str_starts_with($mobile,"263")){
                    $mobile = "263".$mobile ;
                }
                $mobile = "+" . $mobile;
                $stockitem = 138;
                $botracho = "credsure";
                $title = $policytype . " " . $policynumber;

                $data = array('subscriber' => $mobile, 'fullname' => $name, 'title' => $title, 'stock_item' => $stockitem,
                    'startdate' => $transactiondate, 'enddate' => $renewaldate, 'botname' => $botracho
                    , "variable_s1" => $policynumber
                    , "status" => "PAID", "variable_s1" => $policynumber);

                if ($name != null || !empty ($ogmobile )) {
                    $s1 = $db->katubu_subscriptions->insert($data);

                    $count = $count + 1;

                    
                    $walink = generate_whatsapp_link("263716853233", "credsure");
                    $customerpolicysms = "Dear <fullname>, Policy "
                            . "<policynumber> expires on <expirydate>. "
                            . "SEND the word CREDSURE to whatsapp number 0716853233 to renew or view policy status" . $walink
                            . " No action needed if paid up";
                    

                    $customerpolicysms = str_replace("<fullname>", $name, $customerpolicysms);
                    $customerpolicysms = str_replace("<policynumber>", $policynumber, $customerpolicysms);
                    $customerpolicysms = str_replace("<transactiondate>", $transactiondate, $customerpolicysms);
                    $customerpolicysms = str_replace("<expirydate>", $renewaldate, $customerpolicysms);

                    $data = array("recipient" => $mobile, "message" => $customerpolicysms, "status" => "UNSENT", "platformtype" => "SMS");
                    //$s1 = $db->katubu_bulk_messages->insert($data);
                    send_sms($mobile, $customerpolicysms);
                }
            }

            fclose($file);
            $response = "We have processed " . $count . " row(s)";
        }
    }
}

if (str_contains($response, '{{process_upload_action}}')) {

    $admin1 = "263772545900";
    $admin2 = "263773971318";
    $admin3 = "263774139346";
    $amount = $session['variable_s4'] . " " . $session['variable_s5'];
    $expires = $session['variable_s1'];

    $lastnextconversation = $session['nextconversationline'];

    if (!empty($filenamereceipt) || $filenamereceipt != null) {

        $file_ext = pathinfo($filenamereceipt, PATHINFO_EXTENSION);
        $ordernumber = $session['ordernumber'];
        $filenamereceipt = $ordernumber . "." . $file_ext;

        // $filenamereceipt = trim($filenamereceipt);
        // $filenamereceipt = str_replace(" ", "_", $filenamereceipt);

        $imageurl = $fileslink . $filenamereceipt;
        $data = array('number' => $number, 'reference' => $session['ordernumber']
            , 'amount' => $amount, 'status' => "DEPOSITED", 'document_link' => $imageurl,
            "expires" => $expires);

        $s1 = $db->payment_approvals->insert($data);

        $filelink = download_receipt($filenamereceipt, $fileurl, $deviceid, $filenamereceipt);
        //download_receipt_new();
        $txt = "Client: " . $number . "\nAmount: " . $amount . "\nReference: " . $session['ordernumber'] . "\nPOP Link: " . $imageurl; //"\nPOP: " . $filelink . "\nFilename: " . $filenamereceipt . "\nFile ID: " . $filenamereceiptID;
        $txt = "*REQUEST TO APPROVE PAYMENT*\n\n" . $txt . "\n\nhttps://wa.me/" . $botnumber . "?text=Approve+payment+" . $session['ordernumber'];

        $txt = "Client: " . $number . "\nAmount: " . $amount . "\nReference: " . $session['ordernumber']; //. "\nPOP Link: " . $imageurl; //"\nPOP: " . $filelink . "\nFilename: " . $filenamereceipt . "\nFile ID: " . $filenamereceiptID;
        $txt = "*REQUEST TO APPROVE PAYMENT*\n\n" . $txt . "\n\nhttps://wa.me/" . $botnumber . "?text=Approve+payment+" . $session['ordernumber'];

        //Send Message to admins 
        //$admins = $db->katubu_bot_owners();
        $admins = $db->katubu_bot_owners()->where("status", "ACTIVE");
        foreach ($admins as $admin) {
            // reply_message($admin['number'], $txt, $messagetype);
            send_multimedia($imageurl, $txt, $admin['number']);
        }

        $txt = "";
        $response = str_replace("{{process_upload_action}}", $txt, $response);
    } else {
        $isKeyword = true;

        $lines = $db->katubu_whatsapp_conversation_lines()->where("id", 24);
        foreach ($lines as $line) {
            $response = $line['title'];
            $action = $line['before_action'];
            $data = array('nextconversationline' => $line['nextline'], 'storesponse' => $line['storevariable'], 'context' => "", 'ordernumber' => $reference);
            saveSession($session['number'], $db, $data);
        }
    }

    /*  $admin1 = "263772545900";
      $admin2 = "263773971318";
      $admin3 = "263774139346";
      $amount = $session['variable_s4'] . " " . $session['variable_s5'];
      $expires = $session['variable_s1'];
      $imageurl = $fileslink . $filenamereceipt;

      $data = array('number' => $number, 'reference' => $session['ordernumber']
      , 'amount' => $amount, 'status' => "DEPOSITED", 'document_link' => $imageurl,
      "expires" => $expires);

      $s1 = $db->payment_approvals->insert($data);

      $filelink = download_receipt($filenamereceipt, $fileurl, $deviceid, $filenamereceipt);
      //download_receipt_new();
      $txt = "Client: " . $number . "\nAmount: " . $amount . "\nReference: " . $session['ordernumber']; //. "\nPOP Link: " . $imageurl; //"\nPOP: " . $filelink . "\nFilename: " . $filenamereceipt . "\nFile ID: " . $filenamereceiptID;

      $txt = "*REQUEST TO APPROVE PAYMENT*\n\n" . $txt . "\n\nhttps://wa.me/" . $botnumber . "?text=Approve+payment+" . $session['ordernumber'];

      //Send Message to admins

      $admins = $db->katubu_bot_owners()->where("status", "ACTIVE");
      foreach ($admins as $admin) {
      // reply_message($admin['number'], $txt, $messagetype);
      send_multimedia($imageurl, $txt, $admin['number']);
      }


      $txt = "";
      $response = str_replace("{{process_upload_action}}", $txt, $response); */
}

if (str_contains($response, '{{paymentamount}}')) {

    $amount = $session['variable_s4'] . " " . $session['variable_s6'];
    $response = str_replace("{{paymentamount}}", $amount, $response);
}

function download_receipt($filename, $fileurl, $deviceid, $zitarefile) {

    $isDone = false;
    $fileId = $GLOBALS['filenamereceiptID'];

    // $url = 'https://api.wassenger.com/v1/chat/' . $deviceid . '/files/' . $filename . '/download';
    $url = 'https://api.wassenger.com/v1/chat/' . $deviceid . '/files/' . $fileId . '/download';

    //$url = "https://api.wassenger.com/v1/files/" . $fileId . "/download";

    $destination = 'receipts/' . $zitarefile;

    $curl = curl_init();

    curl_setopt_array($curl, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => "",
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => "GET",
        // CURLOPT_POSTFIELDS => "{\"phone\":\"+27711719346\",\"message\":\"We have successfully downloaded the receipt\"}",
        CURLOPT_HTTPHEADER => [
            //   "Content-Type: application/json",
            "Token: " . $GLOBALS['tokenkey']
        ],
    ]);

    $file = curl_exec($curl);
    $number = $GLOBALS['number'];
    $messagetype = "text";

    $err = curl_error($curl);

    if ($file === false) {
        $message = "Failed to download the file.\n\n" . $url . "\n\n" . $err;
        //reply_message($number, $message, $messagetype);
        echo $message;
    } else {
        // Save the downloaded file to the destination path
        $fp = fopen($destination, 'w');
        fwrite($fp, $file);
        fclose($fp);
        $isDone = true;
        $message = "File downloaded successfully. \n" . $file . "\n\n" . $url;
        //reply_message($number, $message, $messagetype);
        echo $message;
    }

// Close cURL session
    curl_close($curl);
    return $isDone;
    ;
}

function send_image_to_chat($usernumber, $link) {
    
}

function download_receipt_new() {


    $curl = curl_init();
    $fileId = $GLOBALS['filenamereceiptID'];
    $url = "https://api.wassenger.com/v1/files/" . $fileId . "/download";
    $destination = 'receipts/' . $zitarefile;

    curl_setopt_array($curl, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => "",
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => "GET",
        CURLOPT_HTTPHEADER => [
            "Token: " . $GLOBALS['tokenkey']
        ],
    ]);

    $file = curl_exec($curl);
    $number = $GLOBALS['number'];
    $messagetype = "text";

    $err = curl_error($curl);

    if ($file === false) {
        $message = "Failed to download the file.\n\n" . $url . "\n\n" . $err;
        //  reply_message($number, $message, $messagetype);
        echo $message;
    } else {
        // Save the downloaded file to the destination path
        $fp = fopen($destination, 'w');
        fwrite($fp, $file);
        fclose($fp);

        $message = "File downloaded successfully. \n" . $file;
        reply_message($number, $message, $messagetype);
        echo $message;
    }

// Close cURL session
    curl_close($curl);

    /* $response = curl_exec($curl);
      $err = curl_error($curl);

      curl_close($curl);

      if ($err) {
      echo "cURL Error #:" . $err;
      } else {
      echo $response;
      } */
    return $destination;
}
