<?php

//Let get the latest session details 

$session = getSession($number, $db);

//FIELD REPLACEMENTS FOR DYNAMIC RESPONSES 

if (str_contains($response, '{{set_context_to_upload_menu}}')) {

    $data = array('context' => "Upload POP Menu");
    saveSession($number, $db, $data);
}

if (str_contains($response, '{{send_pop_to_admin}}')) {

    $details = null;
    $otherdetails = null;

    $file_ext = pathinfo($filenamereceipt, PATHINFO_EXTENSION);
    $ordernumber = $session['ordernumber'];
    $filenamereceipt = $ordernumber . "." . $file_ext;

    $imageurl = $fileslink . $filenamereceipt;
    $isdone = download_receipt($filenamereceipt, $fileurl, $deviceid, $filenamereceipt);

    if ($isdone) {

        //Lets get quotation details here and send them. 
        $policies = $db->katubu_quotations()->where("subscriber", $number);

        foreach ($policies as $policy) {
            $details = $policy['details'];
            $otherdetails = $policy['otherdetails'];
        }

        $schedulelink = "send_customer_schedule # " . $number . " # " . " <enter policy number > # <Enter item insured> # <enter expiry date dd-mm-yyyy> ";
        $link = generate_whatsapp_link($botnumber, $schedulelink);

        //Send to Admin 
        $txttosend = "Credsure POP Submission\n\n\nClient: " . $number . "\nName: " . $session['name']
                . "\n\nQuotation: " . $details . "\n\nPolicies:\n" . $otherdetails . "\n\nSend Schedule Link\n" . $link;

        // $applink = generate_whatsapp_link($mobile, $txttosend);

        $admins = $db->katubu_bot_owners()->where("botname", $botname)->where("status", "ACTIVE")->where("roles LIKE '%admin%'");

        foreach ($admins as $admin) {
            send_multimedia($imageurl, $txttosend, $admin['number']);
        }

        $response = str_replace("{{send_pop_to_admin}}", "", $response);
    }
}

if (str_contains($response, '{{current_susbcriptions}}')) {

    $subscriptions = $db->katubu_subscriptions()->where('botname', $botname)->where("subscriber", $number);
    $txt = "";

    foreach ($subscriptions as $sub) {

        if ($sub['status'] == "PAID") {
            //  $formattedDate = date("d-M-Y", $sub['enddate']);
            //$date = DateTime::createFromFormat('Y-m-d', $sub['enddate']); 
            $txt = "\n" . $sub['title'];
            $date = $sub['enddate'];
            $txt = $txt . "\nExpires: " . $date;
            $fullname = $sub['fullname'];
        }
    }

    //Update variable s2 in prep for next phase 

    $response = str_replace("{{current_susbcriptions}}", $txt, $response);
    $txt = "Client Name: " . $fullname . "\n" . $txt;
    $data = array('variable_s2' => $txt);
    saveSession($number, $db, $data);
}


if (str_contains($response, '{{quotation_details}}')) {
    $quotedetails = $session['variable_s2'];
}


if (str_contains($response, '{{subscriptions}}')) {

    $categoryId = $session['variable_s3'];
    $optionId = $session['variable_s5'];
    $category = null;
    $option = null;

    $categories = $db->katubu_stock_categories()->where('botname', $botname)->where("idnumber", $categoryId);
    foreach ($categories as $cat) {
        $category = $cat;

        $options = $db->katubu_stock_items()->where('botname', $botname)->where("position", $optionId)->where("category", $cat['id']);
        foreach ($options as $opt) {
            $option = $opt;
        }
    }



    if ($category != null && $option != null) {
        $txt = "Discipline: " . $category['description'] . " " . $option['items'] . "\nthat costs " . $option['price'] . " " . $option['currency'];

        //Lets add to the subscriptions table. 
        $title = trim($category['description']) . " (" . trim($option['items']) . ")";
        $data = array('subscriber' => $number, 'title' => $title, 'stock_item' => $option['id'],
            'amount' => $option['price'], 'currency' => $option['currency'], 'botname' => $botname);
        $s1 = $db->katubu_subscriptions->insert($data);
    }
    $response = str_replace("{{subscriptions}}", $txt, $response);
}

if (str_contains($response, '{{notify_customer_support}}')) {

    $customerteams = $db->katubu_bot_owners()->where("botname", $botname)->where("roles LIKE '%customers%'");
    $txt = ""; //$txt = $customerteams ;

    foreach ($customerteams as $member) {


        $text = "I am from " . $botname . ", you made an inquiry about '_*" . $session['variable_s1'] . "*_'";

        $link = generate_whatsapp_link($number, $text);
        $flight = "*CUSTOMER QUERY* \n\n Please note that the following client wants to talk to customer support \n\nINQUIRY: " . $session['variable_s1']
                . "\n\nTalk to them here\n\n" . $link;

        reply_message($member['number'], $flight, $messagetype);
    }
    $response = str_replace("{{notify_customer_support}}", $txt, $response);
}



if (str_contains($response, '{{notify_customer_teams}}')) {

    $customerteams = $db->katubu_bot_owners()->where("botname", $botname)->where("roles LIKE '%customer%'");
    $txt = ""; //$txt = $customerteams ;

    foreach ($customerteams as $member) {

        $subscriptions = $db->katubu_subscriptions()->where('botname', $botname)->where("subscriber", $number);
        $details = null;
        $name = null;
        $policynumber = null;

        foreach ($subscriptions as $sub) {
            $details = $sub['title'];
            $policynumber = $sub['variable_s1'];
            $name = $sub['fullname'];
        }
        $text = "I am from " . $botname . ", i understand you would like to make a payment for " . $details;

        $link = generate_whatsapp_link($number, $text);
        $flight = "*CUSTOMER REQUESTS* \n\n Please note that the following client wants to pay cash for a premium"
                . "\n\n" . $details . "\n\nTalk to them here\n\n" . $link;

        reply_message($member['number'], $flight, $messagetype);
    }
    $response = str_replace("{{notify_customer_teams}}", $txt, $response);
}

if (str_contains($response, '{{disciplines}}')) {

    $disciplines = $db->katubu_stock_categories()->where('botname', $botname)->order("idnumber DESC")->where("status", "ACTIVE");
    $txt = "";

    foreach ($disciplines as $discipline) {
        $txt = "\n*" . $discipline['idnumber'] . "*. " . $discipline['description'] . " " . $txt;
    }
    $response = str_replace("{{disciplines}}", $txt, $response);
}

if (str_contains($response, '{agentbotlink}')) {

    $str = "transactionpremium  *   transactiondate  *  levy  *  expirydates   *  effectivedates * "
            . " stampduty  * amountpaid * zinara * zbc * manufactureyear * vehicleregnumber * carmodel "
            . "* clientname * phonenumber ";

    $link = generate_whatsapp_link($botnumber, $str);
    $response = str_replace("{agentbotlink}", $link, $response);
}

function getcurrencycode($amount) {
    // Adjusted regex to allow optional whitespace between code and amount
    preg_match('/^([A-Za-z]+)\s*([\d,.]+)/', $amount, $matches);

    if (!empty($matches)) {
        $currencyCode = $matches[1]; // Result: currency code
        $numericValue = $matches[2]; // Result: numeric value

       // echo "Currency Code: " . $currencyCode . " | Value = " . $numericValue;
    } else {
        // echo "No match found. Ensure the format is 'CODE1234.56' or 'CODE 1234.56'";
    }

    return $matches;
}

if (str_contains($response, '{{validatepolicy}}')) {

    /* $str = "transactionpremium  *   transactiondate  *  levy  *  expirydates   *  effectivedates * "
      . " stampduty  * amountpaid * zinara * zbc * manufactureyear * vehicleregnumber * carmodel "
      . "* clientname * phonenumber "; */
    $txt = "We have saved uploaded the policy details successfully to upload another or go  to menu reply *rea* ";

    $arrayfr = explode("*", $session['variable_s1']);
    if (count($arrayfr) > 10) {

        $indexcurrency = 1 ;
        $indexamount = 2 ;
        
        $transactionarray = getcurrencycode(trim($arrayfr[0]));
        $transactionpremium = $transactionarray[$indexamount];
        $transactioncurrency = $transactionarray[$indexcurrency];

        $transactiondate = strtotime(trim($transactionarray[1]));
        $levyarray = getcurrencycode(trim($arrayfr[2]));
        $levy = $levyarray[$indexamount];
        $levycurrency = $levyarray[$indexcurrency];

        $expirydates = strtotime(trim($arrayfr[3]));
        $effectivedates = strtotime(trim($arrayfr[4]));

        $stamparray = getcurrencycode(trim($arrayfr[5]));
        $stampduty = $stamparray[$indexamount];
        $stampcurrency = $stamparray[$indexcurrency];

        $amountarray = getcurrencycode(trim($arrayfr[6]));
        $amountpaid = $amountarray[$indexamount];
        $amountcurrency = $amountarray[$indexcurrency];

        $zinaraarray = getcurrencycode(trim($arrayfr[7]));
        $zinara = $zinaraarray[$indexamount];
        $zinaracurrency = $zinaraarray[$indexcurrency];

        $zbcarray = getcurrencycode(trim($arrayfr[8]));
        $zbc = $zbcarray[$indexamount];
        $zbccurrency = $zbcarray[$indexcurrency];

        $manufactureyear = trim($arrayfr[9]);
        $vehicleregnumber = trim($arrayfr[10]);
        $carmodel = trim($arrayfr[11]);
        $clientname = trim($arrayfr[12]);
        $phonenumber = trim($arrayfr[13]);

        /* {"clientId":1729592599939,"transactionPremium":2000,"transactionDate":1729592601867
         * ,"levy":34,"expiryDate":1730370205055,"stampDuty":45,"amountPaid":2379,"currency":"USD"
         * ,"zbc":100,"commission":22,"id":1729592701356,"zinara":200,"manufactureYear":1667298204922
         * ,"effectiveDate":1728987804993,"vehicleRegNumber":"ZZZ 9000","carModel":"Koenigsegg Agera"} */
        $agent = $number;

        $array = array(
            "clientId" => time()
            , "transactionPremium" => $transactionpremium
            , "transactionDate" => time()
            , "levy" => $levy
            , "expiryDate" => $expirydates
            , "stampDuty" => $stampduty
            , "amountPaid" => $amountpaid
            , "currency" => $transactioncurrency
            , "zbc" => $zbc
            , "commission" => 0
            , "id" => time()
            , "zinara" => $zinara
            , "manufactureYear" => $manufactureyear
            , "effectiveDate" => $effectivedates
            , "vehicleRegNumber" => $vehicleregnumber
            , "carModel" => $carmodel
        );
//Koenigsegg Agera # ZZZ 9000 # 122 # 2379.0 USD # Mabhutsu Ekarate # +263775060124
        $preview = $carmodel . " # " . $vehicleregnumber . " # " . $manufactureyear . " # " . $transactionpremium . " " . $transactioncurrency . " # " . $clientname . " # " . $clientnumber;
        $jsondata = json_encode($array);
        $data = array(
            "snapshot" => $arrayfr[0]
            , "agent" => $agent
            , "json" => $jsondata
            , "preview" => $preview
        );
        $s1 = $db2->imuploads->insert($data);
        if ($s1) {
            
        } else {
            $txt = "*Error*"
                    . ""
                    . "Please note there was an error submitting your profile. Please make sure you have followed capture instructions to the dot. "
                    . ""
                    . "Repply *rea* to start again";
        }
    } else {
        $txt = "Insufficient number of fields. Please retry again using the provided format.";
    }

    $response = str_replace("{validatepolicy}", $link, $txt);
}

if (str_contains($response, '{{quotation_details}}')) {

    $txt = "";
    //  $session = getSession($number, $db);
    $categorydescription = "";
    $catId = 0;
    $disciplines = $db->katubu_stock_categories()->where('botname', $botname)->where("idnumber", $session['variable_s3']);
    $txt = "";

    foreach ($disciplines as $discipline) {
        $categorydescription = $discipline['description'];
        $catId = $discipline['id'];
    }
    $options = $db->katubu_stock_items()->where('botname', $botname)->where("category", $catId)->where("position", $session['variable_s6']);
    $sql = $options;
    //$txt = " ".$sql ;
    // reply_message($botdevelopment, "Options: ".$sql, $messagetype);

    foreach ($options as $option) {

        $amount = number_format($option['cover'], 2, '.', ',');
        $price = number_format($option['price'], 2, '.', ',');
        $txt = "\n\n*" . trim($categorydescription)
                . "*" . display_quote($option['cover'], $option['price'], $option['position'], $option['currency']);
        //"* \n\nCover Limit: " . $amount . " " . $option['currency'] . "\n_*Pay: " . $price . "*_ " . $option['currency'] . $txt;
    }

    $data = array('nextconversationline' => 0, 'storesponse' => "", 'context' => "Confirm Quote");
    saveSession($number, $db, $data);
    $response = str_replace("{{quotation_details}}", $txt, $response);
}

if (str_contains($response, '{{payment_option_menu}}')) {

    $data = array(
        'storesponse' => 'variable_s6',
        'context' => "Payment Options",
    );
    saveSession($session['number'], $db, $data);
    $response = str_replace("{{payment_option_menu}}", "", $response);
}



if (str_contains($response, '{{premium_options}}')) {

    $txt = "";
    $stockId = 0;

    $subscriptions = $db->katubu_subscriptions()->where('botname', $botname)->where("subscriber", $number);
    foreach ($subscriptions as $sub) {
        $stockId = $sub['stock_item'];
    }


    $options = $db->katubu_stock_items()->where('botname', $botname)->where("id", $stockId);
    $sql = $options;

    foreach ($options as $option) {

        $amount = $option['cover'];
        $price = $option['price'];
        $currency = $option['currency'];
        $position = 0;

        $txt = display_premium_options($amount, $price, $position, $currency, $number, $db);
    }


    $response = str_replace("{{premium_options}}", $txt, $response);
}

function display_premium_options($cover, $annual, $position, $currency, $number, $db) {

    $stampduty = $GLOBALS['stampduty'];
    $annual = ($annual * $stampduty) + $annual;
    $amount = number_format($annual, 2, '.', ',');

    $biannual = $annual / 2;
    $biannual = ($biannual * $stampduty) + $biannual;
    $biannual = number_format($biannual, 2, '.', ',');

    $quarterly = $annual / 4;
    $quarterly = ($quarterly * $stampduty) + $quarterly;
    $quarterly = number_format($quarterly, 2, '.', ',');

    $txt = "\n_REQUIRED PREMIUM OPTIONS_ \n*1. Annual: " . $amount . " " . $currency . "*"
            . "\n*2. Biannual: " . $biannual . " " . $currency . "*"
            . "\n*3. Quarterly: " . $quarterly . " " . $currency . "*"
    ;

    $data = array('nextconversationline' => 0, 'storesponse' => "", 'context' => "Premium Menu",
        'variable_s1' => $amount, 'variable_s2' => $biannual, 'variable_s3' => $quarterly, 'variable_s5' => $currency);

    saveSession($number, $db, $data);

    return $txt;
}

function display_quote($cover, $annual, $position, $currency) {

    $stampduty = $GLOBALS['stampduty'];
    $annual = ($annual * $stampduty) + $annual;
    $amount = number_format($annual, 2, '.', ',');

    $biannual = $annual / 2;
    $biannual = ($biannual * $stampduty) + $biannual;
    $biannual = number_format($biannual, 2, '.', ',');

    $quarterly = $annual / 4;
    $quarterly = ($quarterly * $stampduty) + $quarterly;
    $quarterly = number_format($quarterly, 2, '.', ',');

    $txt = "\n\n*" . $position . ". Cover Limit: " . number_format($cover, 2, '.', ',') . " " . $currency
            . "*\n_REQUIRED PREMIUM OPTIONS_*\n_Annual: " . $amount . " " . $currency . "_"
            . "\n_Biannual: " . $biannual . " " . $currency . "_"
            . "\n_Quarterly: " . $quarterly . " " . $currency . "*_"
    ;
    return $txt;
}

if (str_contains($response, '{{discipline_options}}')) {

    $sql = "";
    $disciplines = $db->katubu_stock_categories()->where('botname', $botname)->where("idnumber", $session['variable_s3'])->order("idnumber DESC");
    $txt = "";

    foreach ($disciplines as $discipline) {

        $options = $db->katubu_stock_items()->where('botname', $botname)->where("category", $discipline['id'])->order("position DESC");
        $sql = $options;

        foreach ($options as $option) {

            $annual = $option['price'];
            $cover = $option['cover'];
            $txt = display_quote($cover, $annual, $option['position'], $option['currency']) . $txt;
        }
    }

    $response = str_replace("{{discipline_options}}", $txt, $response);
    //$response = $sql ;
}

if (str_contains($response, '{{reference}}')) {
    $response = str_replace("{{reference}}", $session['ordernumber'], $response);
}

if (str_contains($response, '{{depositmethod}}')) {
    $method = $session['variable_s5'];
    if ($method == 1) {
        $method = "bank";
    }
    if ($method == 2) {
        $method = "cash";
    }


    $response = str_replace("{{depositmethod}}", $method, $response);
}
if (str_contains($response, '{{send_team_policy_to_client}}')) {

    $recipient = $session['variable_s3'];
    $file_ext = pathinfo($filenamereceipt, PATHINFO_EXTENSION);
    $ordernumber = $session['ordernumber'];
    $filenamereceipt = $ordernumber . "." . $file_ext;

    $imageurl = $fileslink . $filenamereceipt;
    $isdone = download_receipt($filenamereceipt, $fileurl, $deviceid, $filenamereceipt);
    if ($isdone) {
        send_multimedia($imageurl, "Please find herewith your policy", $recipient);
    } else {

        $response = "Failed to send file, please try again in a few minutes";
    }
}

if (str_contains($response, '{{process_upload_customer_db}}')) {

    if (!empty($filenamereceipt) || $filenamereceipt != null) {

        $file_ext = pathinfo($filenamereceipt, PATHINFO_EXTENSION);
        $ordernumber = $session['ordernumber'];
        $filenamereceipt = $ordernumber . "." . $file_ext;

        $imageurl = $fileslink . $filenamereceipt;
        $isdone = download_receipt($filenamereceipt, $fileurl, $deviceid, $filenamereceipt);
        if ($isdone) {

            $filename = 'receipts/' . $filenamereceipt;
            $file = fopen($filename, "r");
            $sample = "";
            $errors = "";

            while (!feof($file)) {
                $line = fgetcsv($file);
                $transactiondate = $line[0];
                //$transactiondate = str_replace("//", "-", $transactiondate);
                $time = strtotime($transactiondate);
                $transactiondate = date('Y-m-d', $time);

                $name = $line[1];
                $policynumber = $line[2];
                $policytype = $line[3];
                $policydescription = $line[4];
                $renewaldate = $line[5];
                // $renewaldate = str_replace("//", "-", $renewaldate);
                $time = strtotime($renewaldate);
                $renewaldate = date('Y-m-d', $time);

                $mobile = $line[6];
                $stockitem = 138;
                $botracho = "credsure";
                $title = $policytype . " " . $policynumber;

                $data = array('subscriber' => $mobile, 'fullname' => $name, 'title' => $title, 'stock_item' => $stockitem,
                    'startdate' => $transactiondate, 'enddate' => $renewaldate, 'botname' => $botracho, 'variable_s1' => $policynumber);

                $s1 = $db->katubu_subscriptions->insert($data);

                $count = $count + 1;
            }

            fclose($file);
            $response = "We have processed " . $count . " rows. Sample Line has items: " . $newformat;
        }
    }
}
if (str_contains($response, '{{send_team_details}}')) {

    $customerteams = $db->katubu_bot_owners()->where("botname", $botname)->where("roles LIKE '%customers%'");
    $txt = ""; //$txt = $customerteams ;
    $session = getSession($number, $db);

    $file_ext = pathinfo($filenamereceipt, PATHINFO_EXTENSION);
    $ordernumber = $session['ordernumber'];
    $filenamereceipt = $ordernumber . "." . $file_ext;
    $res = download_receipt($filenamereceipt, $fileurl, $deviceid, $filenamereceipt);

    foreach ($customerteams as $member) {


        $whatsapplink = "send_policy_schedule # " . $number . " # <policy number> # <expiry date> ";
        $link = generate_whatsapp_link($botnumber, $whatsapplink);

        $flight = "*CUSTOMER PAYMENT APPROVAL REQUEST* \n\n Please note that the following uploaded a payment. Please verify and then upload their schedule using link below\n\nDETAILS: \n"
                . $session['variable_s2']
                . "\n\nSend their policy here\n\n" . $link . "\n";

        // reply_message($member['number'], $flight, $messagetype);
        if ($res) {
            $link = $fileslink . "" . $filenamereceipt;
            send_multimedia($link, $flight, $member['number']);
        }
        // 
    }
    $response = str_replace("{{send_team_details}}", "", $response);
}




if (str_contains($response, '{{notify_customer_support_manual_renewal}}')) {

    $customerteams = $db->katubu_bot_owners()->where("botname", $botname)->where("roles LIKE '%customers%'");
    $txt = ""; //$txt = $customerteams ;
    $session = getSession($number, $db);

    //Lets save t data in the quotations table.  
    $policies = $db->katubu_quotations()->where("subscriber", $number);

    $latestpolicy = null;
    $found = false;

    foreach ($policies as $policy) {

        $latestpolicy = $policy;
        $found = true;
    }
    if ($found == true) {
        $data = array("otherdetails" => "\nCurrent Policy: " . $session['variable_s2'] . " \nNew Request: " . $session['variable_s1']);
        $latestpolicy->update($data);
    } else {
        $data = array("otherdetails" => "\nCurrent Policy: " . $session['variable_s2'] . " \nNew Request: " . $session['variable_s1'],
            "subscriber" => $number, "status" => "QUOTATION", "botname" => $botname);
        $db->katubu_quotations->insert($data);
    }


    foreach ($customerteams as $member) {


        $whatsapplink = "send_quotation # " . $number . " # " . " <enter quotation details > ";
        $link = generate_whatsapp_link($botnumber, $whatsapplink);

        $flight = "*CUSTOMER QUOTATION REQUEST* \n\n Please note that the following client wants a quote \n\nDETAILS: " . $session['variable_s2'] . "\n\nNew Requests: " . $session['variable_s1']
                . "\n\nReply Quote here\n\n" . $link;

        reply_message($member['number'], $flight, $messagetype);
    }
    $response = str_replace("{{notify_customer_support_manual_renewal}}", "", $response);
}

if (str_contains($response, '{{validate_and_send_policy}}')) {


    $info = $session['variable_s1'];

    $lastnextconversation = $session['nextconversationline'];

    if (!empty($filenamereceipt) || $filenamereceipt != null) {

        $file_ext = pathinfo($filenamereceipt, PATHINFO_EXTENSION);
        $ordernumber = $session['ordernumber'];
        $filenamereceipt = $ordernumber . "_policy." . $file_ext;
        $tolower = strtolower($info);
        $filelink = download_receipt($filenamereceipt, $fileurl, $deviceid, $filenamereceipt);

        if (str_starts_with($tolower, "r")) {
            $info = explode("#", $info);
            $policy = $info[1];
            $policydetails = $info['2'];
            $expiry = $info['3'];
            $time = strtotime($expiry);
            $renewaldate = date('Y-m-d', $time);
            //Check if it exists 
            $subscriptions = $db->katubu_subscriptions()->where("title LIKE %" . $policynumber . "%");
            $txt = "";
            $found = false;
            $policyholdder = "";
            foreach ($subscriptions as $sub) {

                $found = true;
                $data = array("title" => $policydetails, "enddate" => $renewaldate);
                $sub->update($data);
                $policyholdder = $sub['subscriber'];
            }
            if ($found) {
                //Lets send the recipient their policy. 
                $response = "We have successfully sent the policy document";
                $txt = "Dear " . $name . " please find herewith your policy schedule";
                send_multimedia($filelink, $txt, $policyholdder);
            } else {
                $response = "Invalid Policy Number. Please restart the process";
            }
        }
        if (str_starts_with($tolower, "n")) {
            $info = explode("#", $info);
        }




        //$response = str_replace("{{validate_and_send_policy}}", $txt, $response);
    } else {
        $isKeyword = true;
        $response = "Invalid file upload. Open botadmin menu and start again";
    }
}



if (str_contains($response, '{{process_upload_action}}')) {

    $admin1 = "263772545900";
    $admin2 = "263773971318";
    $admin3 = "263774139346";
    $amount = $session['variable_s4'] . " " . $session['variable_s5'];
    $expires = $session['variable_s1'];

    $lastnextconversation = $session['nextconversationline'];

    if (!empty($filenamereceipt) || $filenamereceipt != null) {

        $file_ext = pathinfo($filenamereceipt, PATHINFO_EXTENSION);
        $ordernumber = $session['ordernumber'];
        $filenamereceipt = $ordernumber . "." . $file_ext;

        // $filenamereceipt = trim($filenamereceipt);
        // $filenamereceipt = str_replace(" ", "_", $filenamereceipt);

        $imageurl = $fileslink . $filenamereceipt;
        $data = array('number' => $number, 'reference' => $session['ordernumber']
            , 'amount' => $amount, 'status' => "DEPOSITED", 'document_link' => $imageurl,
            "expires" => $expires);

        $s1 = $db->payment_approvals->insert($data);

        $filelink = download_receipt($filenamereceipt, $fileurl, $deviceid, $filenamereceipt);
        //download_receipt_new();
        $txt = "Client: " . $number . "\nAmount: " . $amount . "\nReference: " . $session['ordernumber'] . "\nPOP Link: " . $imageurl; //"\nPOP: " . $filelink . "\nFilename: " . $filenamereceipt . "\nFile ID: " . $filenamereceiptID;
        $txt = "*REQUEST TO APPROVE PAYMENT*\n\n" . $txt . "\n\nhttps://wa.me/" . $botnumber . "?text=Approve+payment+" . $session['ordernumber'];

        $txt = "Client: " . $number . "\nAmount: " . $amount . "\nReference: " . $session['ordernumber']; //. "\nPOP Link: " . $imageurl; //"\nPOP: " . $filelink . "\nFilename: " . $filenamereceipt . "\nFile ID: " . $filenamereceiptID;
        $txt = "*REQUEST TO APPROVE PAYMENT*\n\n" . $txt . "\n\nhttps://wa.me/" . $botnumber . "?text=Approve+payment+" . $session['ordernumber'];

        //Send Message to admins 
        //$admins = $db->katubu_bot_owners();
        $admins = $db->katubu_bot_owners()->where("status", "ACTIVE");
        foreach ($admins as $admin) {
            // reply_message($admin['number'], $txt, $messagetype);
            send_multimedia($imageurl, $txt, $admin['number']);
        }

        $txt = "";
        $response = str_replace("{{process_upload_action}}", $txt, $response);
    } else {
        $isKeyword = true;

        $lines = $db->katubu_whatsapp_conversation_lines()->where("id", 24);
        foreach ($lines as $line) {
            $response = $line['title'];
            $action = $line['before_action'];
            $data = array('nextconversationline' => $line['nextline'], 'storesponse' => $line['storevariable'], 'context' => "", 'ordernumber' => $reference);
            saveSession($session['number'], $db, $data);
        }
    }

    /*  $admin1 = "263772545900";
      $admin2 = "263773971318";
      $admin3 = "263774139346";
      $amount = $session['variable_s4'] . " " . $session['variable_s5'];
      $expires = $session['variable_s1'];
      $imageurl = $fileslink . $filenamereceipt;

      $data = array('number' => $number, 'reference' => $session['ordernumber']
      , 'amount' => $amount, 'status' => "DEPOSITED", 'document_link' => $imageurl,
      "expires" => $expires);

      $s1 = $db->payment_approvals->insert($data);

      $filelink = download_receipt($filenamereceipt, $fileurl, $deviceid, $filenamereceipt);
      //download_receipt_new();
      $txt = "Client: " . $number . "\nAmount: " . $amount . "\nReference: " . $session['ordernumber']; //. "\nPOP Link: " . $imageurl; //"\nPOP: " . $filelink . "\nFilename: " . $filenamereceipt . "\nFile ID: " . $filenamereceiptID;

      $txt = "*REQUEST TO APPROVE PAYMENT*\n\n" . $txt . "\n\nhttps://wa.me/" . $botnumber . "?text=Approve+payment+" . $session['ordernumber'];

      //Send Message to admins

      $admins = $db->katubu_bot_owners()->where("status", "ACTIVE");
      foreach ($admins as $admin) {
      // reply_message($admin['number'], $txt, $messagetype);
      send_multimedia($imageurl, $txt, $admin['number']);
      }


      $txt = "";
      $response = str_replace("{{process_upload_action}}", $txt, $response); */
}

if (str_contains($response, '{{paymentamount}}')) {

    $amount = $session['variable_s4'] . " " . $session['variable_s6'];
    $response = str_replace("{{paymentamount}}", $amount, $response);
}

function download_receipt($filename, $fileurl, $deviceid, $zitarefile) {

    $isDone = false;
    $fileId = $GLOBALS['filenamereceiptID'];

    // $url = 'https://api.wassenger.com/v1/chat/' . $deviceid . '/files/' . $filename . '/download';
    $url = 'https://api.wassenger.com/v1/chat/' . $deviceid . '/files/' . $fileId . '/download';

    //$url = "https://api.wassenger.com/v1/files/" . $fileId . "/download";

    $destination = 'receipts/' . $zitarefile;

    $curl = curl_init();

    curl_setopt_array($curl, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => "",
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => "GET",
        // CURLOPT_POSTFIELDS => "{\"phone\":\"+27711719346\",\"message\":\"We have successfully downloaded the receipt\"}",
        CURLOPT_HTTPHEADER => [
            //   "Content-Type: application/json",
            "Token: " . $GLOBALS['tokenkey']
        ],
    ]);

    $file = curl_exec($curl);
    $number = $GLOBALS['number'];
    $messagetype = "text";

    $err = curl_error($curl);

    if ($file === false) {
        $message = "Failed to download the file.\n\n" . $url . "\n\n" . $err;
        //reply_message($number, $message, $messagetype);
        echo $message;
    } else {
        // Save the downloaded file to the destination path
        $fp = fopen($destination, 'w');
        fwrite($fp, $file);
        fclose($fp);
        $isDone = true;
        $message = "File downloaded successfully. \n" . $file . "\n\n" . $url;
        //reply_message($number, $message, $messagetype);
        echo $message;
    }

// Close cURL session
    curl_close($curl);
    return $isDone;
    ;
}

function send_image_to_chat($usernumber, $link) {
    
}

function download_receipt_new() {


    $curl = curl_init();
    $fileId = $GLOBALS['filenamereceiptID'];
    $url = "https://api.wassenger.com/v1/files/" . $fileId . "/download";
    $destination = 'receipts/' . $zitarefile;

    curl_setopt_array($curl, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => "",
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => "GET",
        CURLOPT_HTTPHEADER => [
            "Token: " . $GLOBALS['tokenkey']
        ],
    ]);

    $file = curl_exec($curl);
    $number = $GLOBALS['number'];
    $messagetype = "text";

    $err = curl_error($curl);

    if ($file === false) {
        $message = "Failed to download the file.\n\n" . $url . "\n\n" . $err;
        //  reply_message($number, $message, $messagetype);
        echo $message;
    } else {
        // Save the downloaded file to the destination path
        $fp = fopen($destination, 'w');
        fwrite($fp, $file);
        fclose($fp);

        $message = "File downloaded successfully. \n" . $file;
        reply_message($number, $message, $messagetype);
        echo $message;
    }

// Close cURL session
    curl_close($curl);

    /* $response = curl_exec($curl);
      $err = curl_error($curl);

      curl_close($curl);

      if ($err) {
      echo "cURL Error #:" . $err;
      } else {
      echo $response;
      } */
    return $destination;
}
