<?php

function callChatGPT($prompt, $apiKey) {
    // API Endpoint
    $url = 'https://api.openai.com/v1/chat/completions';
    
    // Initialize cURL session
    $ch = curl_init($url);
    
    // Request payload
    $data = [
        'model' => 'gpt-3.5-turbo',
        'messages' => [
            [
                'role' => 'user',
                'content' => $prompt,
            ],
        ],
        'max_tokens' => 150,
        'temperature' => 0.7,
    ];
    
    // JSON encode the data
    $payload = json_encode($data);
    
    // Set cURL options
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Authorization: Bearer ' . $apiKey,
        'Content-Type: application/json',
    ]);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    
    // Execute cURL request
    $response = curl_exec($ch);
    
    // Check for cURL errors
    if (curl_errno($ch)) {
        throw new Exception('cURL Error: ' . curl_error($ch));
    }
    
    // Close cURL session
    curl_close($ch);
    
    // Debug: Print the raw response
    echo "Raw Response:\n$response\n";

    // Decode the response
    $data = json_decode($response, true);

    // Debug: Print the parsed response
    if (json_last_error() === JSON_ERROR_NONE) {
        echo "Parsed Response:\n";
        print_r($data);
    } else {
        echo "JSON Parse Error: " . json_last_error_msg() . "\n";
    }

    // Check if the 'choices' key exists and return the content
    if (isset($data['choices']) && isset($data['choices'][0]['message']['content'])) {
        return $data['choices'][0]['message']['content'];
    } else {
        throw new Exception('Unexpected API response structure.');
    }
}

// Replace 'your_api_key_here' with your actual OpenAI API key
$apiKey = 'sk-proj-dvyTCB0eL4LnWAENGJcYT3BlbkFJKgPp78CI0lXlbArhgjEJ';
$prompt = 'Follow up Tafadzwa ten days from now if they are ready to make a payment for the policy.';

// Function to calculate the date ten days from now
function getFollowUpDate($days = 10) {
    return date('Y-m-d', strtotime("+$days days"));
}

// Modify the prompt to include instructions for ChatGPT to format the response as JSON
$followUpDate = getFollowUpDate();
$modifiedPrompt = "Create a JSON object with the following structure: {'action': 'Follow up', 'target': 'Tafadzwa', 'reminder_date': 'YYYY-MM-DD', 'message': 'Check if they are ready to make a payment for the policy'}. Use the reminder date $followUpDate.";

// Call the function to get the response from ChatGPT
try {
    $result = callChatGPT($modifiedPrompt, $apiKey);

    // Print the JSON object returned by ChatGPT
    echo "ChatGPT JSON Response: \n$result\n";

    // Optionally, decode and print the JSON object in a readable format
    $responseData = json_decode($result, true);
    echo "\nFormatted JSON Output:\n";
    echo json_encode($responseData, JSON_PRETTY_PRINT);

} catch (Exception $e) {
    echo 'Error: ' . $e->getMessage() . "\n";
}
