<?php

$imagespath = 'https://cresterp.com/api/uploads/uploads/';

function process_basic_info_html($app, $db, $website, $team, $moduleinfo, $module) {
    $htmlcode = "Please add and publish more modules";
    $row1 = $db->websites()->where("website_app_id", $website)->where("team", $team);
    if ($siteinfo = $row1->fetch()) {
        //Lets breakdown the module info to see what we have here. 
        $moduledecoded = json_decode($moduleinfo);
        $template = $siteinfo['template'];
        $layout = "layout1";


        $row2 = $db->websites_template_facelets()->where("template", $template)->where("layout", $layout)->where("module", $module);
        if ($facelet = $row2->fetch()) {

            //Lets get the data flowing here 
            $htmlcode = $facelet['htmlcode'];
            $htmlcode = str_replace("LOGO", 'https://cresterp.com/api/uploads/uploads/' . $moduledecoded->logouploadname, $htmlcode);
            //Lets modify the htmlcode and save it allong with the other information. 

            $contact = $moduledecoded->contact;
            $htmlcode = str_replace("SITE NAME", $moduledecoded->title, $htmlcode);
            $htmlcode = str_replace("SITE_CALL_NUMBER", 'tel:+' . $contact, $htmlcode);
            $whatsapplink = "https://wa.me/" . $contact . "?text=Hi";
            $htmlcode = str_replace("SITE_APP_NUMBER", $whatsapplink, $htmlcode);
        }
    }

    return $htmlcode;
}

function process_save_video_gallery_html($app, $db, $website, $team, $moduleinfo, $module) {
    $htmlcode = "";
    $placeholder = "https://cresterp.com/api/uploads/uploads/video-placeholder.jpg";

    $row1 = $db->websites()->where("website_app_id", $website)->where("team", $team);
    if ($siteinfo = $row1->fetch()) {
        //Lets breakdown the module infor to see what we have here. 
        $moduledecoded = json_decode($moduleinfo);
        $template = $siteinfo['template'];
        $layout = "layout1";


        $row2 = $db->websites_template_facelets()->where("template", $template)->where("layout", $layout)->where("module", $module);

        if ($facelet = $row2->fetch()) {

            //Lets get the data flowing here 
            $htmlcode = $facelet['htmlcode'];
            $html = str_get_html($htmlcode);
            //Lets take the details and assemble the image facelet to add to this. 
            $str = "";
            $row3 = $db->websites_template_facelets()->where("template", $template)->where("layout", $layout)->where("module", "GALLERY_VIDEO_FACET");

            if ($imagefacelet = $row3->fetch()) {
                //		echo $imagefacelet; exit ;  	
                $str = $imagefacelet['htmlcode'];
                echo $str;
                $str = str_replace("TAG_REPLACE", $moduledecoded->category, $str);
                $str = str_replace("IMAGE_REPLACE", $placeholder, $str);
                $str = str_replace("CAPTION_REPLACE", $moduledecoded->title, $str);
            }//Lets save it to the info table 
            //	save_module_image_gallery_facelet ($app,$db,$website,$team,$moduleinfo,$module,$str) ;			
            //Lets deal with light box images here
            $str1 = "";
            $row33 = $db->websites_template_facelets()->where("template", $template)->where("layout", $layout)->where("module", "GALLERY_VIDEO_FACET_LIGHTBOX");
            if ($imagefacelet1 = $row33->fetch()) {
                //		echo $imagefacelet; exit ;  	
                $str1 = $imagefacelet1['htmlcode'];
                $str1 = str_replace("LIGHT_BOX_REPLACE", $placeholder, $str1);
                $str1 = str_replace("ACTIVE_REPLACE", "active", $str1);
            }


            //Here lets deal with carousal image position  
            $str11 = "";
            $row333 = $db->websites_template_facelets()->where("template", $template)->where("layout", $layout)->where("module", "GALLERY_VIDEO_FACET_LIGHTBOX_CAROUSEL");
            if ($imagefacelet11 = $row333->fetch()) {
                //		echo $imagefacelet; exit ;  	
                $str11 = $imagefacelet11['htmlcode'];
                //	$str11  =  str_replace("POSITION" ,"0",$str11);
            }


            try {
                $element = $html->getElementById('#faceletsv');
                $element->innertext = $str;
            } catch (Exception $e) {

                echo "Facelet failed";
                //echo 'Message: ' .$e->getMessage();
            }

            try {
                $element = $html->getElementById('#light_box_imagesv');
                $element->innertext = $str1;
            } catch (Exception $e) {
                //echo 'Message: ' .$e->getMessage();
                echo "Light box failed";
            }

            try {
                $element = $html->getElementById('#light_box_countv');
                $element->innertext = $str11;
            } catch (Exception $e) {
                //echo 'Message: ' .$e->getMessage();
                echo "Light box counters failed";
            }

            //Next we must take the Lightboxes and sort them out as well. 
        }
        //	 var_dump ($moduledecoded); exit (0) ;

        $html = str_replace("FLIMAGEID", "fl" . $moduledecoded->foreignid, $html);
        $html = str_replace("CLIMAGEID", "cl" . $moduledecoded->foreignid, $html);
        $html = str_replace("IMAGEID", $moduledecoded->foreignid, $html);
        $html = str_replace("VIDEO_URL", $moduledecoded->wfield5, $html);
        $html = str_replace("POSITION", 0, $html);
        $html = str_replace("HOST", "", $html);


        $htmlcode = $html;
    }

    return $htmlcode;
}

function process_save_gallery_html($app, $db, $website, $team, $moduleinfo, $module) {
    $htmlcode = "";
    $row1 = $db->websites()->where("website_app_id", $website)->where("team", $team);
    if ($siteinfo = $row1->fetch()) {
        //Lets breakdown the module infor to see what we have here. 
        $moduledecoded = json_decode($moduleinfo);
        $template = $siteinfo['template'];
        $layout = "layout1";


        $row2 = $db->websites_template_facelets()->where("template", $template)->where("layout", $layout)->where("module", $module);

        if ($facelet = $row2->fetch()) {

            //Lets get the data flowing here 
            $htmlcode = $facelet['htmlcode'];
            $html = str_get_html($htmlcode);
            //Lets take the details and assemble the image facelet to add to this. 
            $str = "";
            $row3 = $db->websites_template_facelets()->where("template", $template)->where("layout", $layout)->where("module", "GALLERY_IMAGE_FACET");

            if ($imagefacelet = $row3->fetch()) {
                //		echo $imagefacelet; exit ; 


                if (!empty($moduledecoded->wfield5)) {
                    //Lets modify the title to contain a 
                    $anchorTag = '<a onclick="displayVideo(\'' . $moduledecoded->wfield5 . '\')" style="background-color: red;   color: white;   padding: 1em 1.5em;   text-decoration: none;   text-transform: uppercase;">Play Video</a>';
                    $moduledecoded->title = '<p style="float:left;">'.$moduledecoded->title . '</p> <p style="float:right;">' . $anchorTag.'</p>';
                   
                }
                $str = $imagefacelet['htmlcode'];
                $str = str_replace("TAG_REPLACE", $moduledecoded->category, $str);
                $str = str_replace("IMAGE_REPLACE", $GLOBALS['imagespath'] . $moduledecoded->path, $str);
                //The wifield5 is the one that conatins the youtube code. 
                $str = str_replace("CAPTION_REPLACE", $moduledecoded->title, $str);
            }//Lets save it to the info table 
            //	save_module_image_gallery_facelet ($app,$db,$website,$team,$moduleinfo,$module,$str) ;			
            //Lets deal with light box images here
            $str1 = "";
            $row33 = $db->websites_template_facelets()->where("template", $template)->where("layout", $layout)->where("module", "GALLERY_IMAGE_FACET_LIGHTBOX");
            if ($imagefacelet1 = $row33->fetch()) {
                //		echo $imagefacelet; exit ;  	
                $str1 = $imagefacelet1['htmlcode'];
                $str1 = str_replace("LIGHT_BOX_REPLACE", $GLOBALS['imagespath'] . $moduledecoded->path, $str1);
                $str1 = str_replace("ACTIVE_REPLACE", "active", $str1);
            }

            //Here lets deal with carousal image position  
            $str11 = "";
            $row333 = $db->websites_template_facelets()->where("template", $template)->where("layout", $layout)->where("module", "GALLERY_IMAGE_FACET_LIGHTBOX_CAROUSEL");
            if ($imagefacelet11 = $row333->fetch()) {
                //		echo $imagefacelet; exit ;  	
                $str11 = $imagefacelet11['htmlcode'];
                //	$str11  =  str_replace("POSITION" ,"0",$str11);
            }

            try {
                $element = $html->getElementById('#facelets');
                $element->innertext = $str;
            } catch (Exception $e) {
                //echo 'Message: ' .$e->getMessage();
            }

            try {
                $element = $html->getElementById('#light_box_images');
                $element->innertext = $str1;
            } catch (Exception $e) {
                //echo 'Message: ' .$e->getMessage();
            }

            try {
                $element = $html->getElementById('#light_box_count');
                $element->innertext = $str11;
            } catch (Exception $e) {
                //echo 'Message: ' .$e->getMessage();
            }

            //Next we must take the Lightboxes and sort them out as well. 
        }


        $html = str_replace("FLIMAGEID", "fl" . $moduledecoded->foreignid, $html);
        $html = str_replace("CLIMAGEID", "cl" . $moduledecoded->foreignid, $html);
        $html = str_replace("IMAGEID", $moduledecoded->foreignid, $html);
        $html = str_replace("POSITION", 0, $html);

        $htmlcode = $html;
    }

    return $htmlcode;
}

function delete_video_gallery($htmlcode, $id, $image) {
    $html = str_get_html($htmlcode);
    try {

        //Check if the element we want to delete is the active one. 
        $item = $html->getElementById('#cl' . $id);
        $todealid = $html->getElementById('#light_box_count')->children(0)->id;
        $search = 'cl' . $id;
        $cmp = strcmp($search, $todealid);
        //	 echo 'First element: '.$todealid.' vs '.$search.' answer: '.$cmp;
        if ($cmp == 0) {
            //We need to move to the next child and set it as active. 
            //	 	echo 'It has an active';
            try {

                $html->getElementById('#light_box_count')->children(2)->{'class'} = 'active';
                $html->getElementById('#light_box_images')->children(2)->class = 'carousel-item active';
                $html->save();
            } catch (Exception $e) {
                //	echo $e->getMessage();
            }
        }
        $html->getElementById('#' . $id)->outertext = "";
        $html->getElementById('#fl' . $id)->outertext = "";
        $html->getElementById('#cl' . $id)->outertext = "";
    } catch (Exception $e) {
        //		echo 'Message: ' .$e->getMessage();
    }

    $html->save();
    $html = process_position_numbers_video_gallery($html);
    $path = '/public_html/api/uploads/uploads/' . $image;
    try {
        unlink($path);
    } catch (Exception $e) {
        
    }
    return $html;
}

function delete_image_gallery($htmlcode, $id, $image) {
    $html = str_get_html($htmlcode);
    try {

        //Check if the element we want to delete is the active one. 
        $item = $html->getElementById('#cl' . $id);
        $todealid = $html->getElementById('#light_box_count')->children(0)->id;
        $search = 'cl' . $id;
        $cmp = strcmp($search, $todealid);
        //	 echo 'First element: '.$todealid.' vs '.$search.' answer: '.$cmp;
        if ($cmp == 0) {
            //We need to move to the next child and set it as active. 
            //	 	echo 'It has an active';
            try {

                $html->getElementById('#light_box_count')->children(2)->{'class'} = 'active';
                $html->getElementById('#light_box_images')->children(2)->class = 'carousel-item active';
                $html->save();
            } catch (Exception $e) {
                //	echo $e->getMessage();
            }
        }
        $html->getElementById('#' . $id)->outertext = "";
        $html->getElementById('#fl' . $id)->outertext = "";
        $html->getElementById('#cl' . $id)->outertext = "";
    } catch (Exception $e) {
        //		echo 'Message: ' .$e->getMessage();
    }

    $html->save();
    $html = process_position_numbers($html);
    $path = '/public_html/api/uploads/uploads/' . $image;
    try {
        unlink($path);
    } catch (Exception $e) {
        
    }
    return $html;
}

function process_position_numbers_video_gallery($htmlcode) {
    $html = str_get_html($htmlcode);
    try {
        $element = $html->getElementById('#faceletsv');
        //	$element->innertext = $element->innertext.$str;
        $vana = $element->children();
        //$pos = count($vana);
        $pos = 0;
        $test = 10;

        foreach ($element->find('img') as $images) {
            $element->children($pos)->children(0)->attr['data-slide-to'] = $pos;
            $pos = $pos + 1;
            //   $element->children($pos)->innertext = $images ;
            $html->save();
        }
    } catch (Exception $e) {
        //		echo 'Message: ' .$e->getMessage();
    }

    //Lets deal with the light box counters here. 
    try {
        $element = $html->getElementById('#light_box_countv');
        //	$element->innertext = $element->innertext.$str;
        $vana = $element->children();
        //$pos = count($vana);
        $pos = 0;
        $test = 10;

        foreach ($element->find('li') as $images) {
            $element->children($pos)->attr['data-slide-to'] = $pos;
            $pos = $pos + 1;
            //   $element->children($pos)->innertext = $images ;
            $html->save();
        }
    } catch (Exception $e) {
        //		echo 'Message: ' .$e->getMessage();
    }

    //echo  $html;
    return $html;
}

function process_position_numbers($htmlcode) {
    $html = str_get_html($htmlcode);
    try {
        $element = $html->getElementById('#facelets');
        //	$element->innertext = $element->innertext.$str;
        $vana = $element->children();
        //$pos = count($vana);
        $pos = 0;
        $test = 10;

        foreach ($element->find('img') as $images) {
            $element->children($pos)->children(0)->attr['data-slide-to'] = $pos;
            $pos = $pos + 1;
            //   $element->children($pos)->innertext = $images ;
            $html->save();
        }
    } catch (Exception $e) {
        //		echo 'Message: ' .$e->getMessage();
    }

    //Lets deal with the light box counters here. 
    try {
        $element = $html->getElementById('#light_box_count');
        //	$element->innertext = $element->innertext.$str;
        $vana = $element->children();
        //$pos = count($vana);
        $pos = 0;
        $test = 10;

        foreach ($element->find('li') as $images) {
            $element->children($pos)->attr['data-slide-to'] = $pos;
            $pos = $pos + 1;
            //   $element->children($pos)->innertext = $images ;
            $html->save();
        }
    } catch (Exception $e) {
        //		echo 'Message: ' .$e->getMessage();
    }

    //echo  $html;
    return $html;
}

function process_save_gallery_image_html($app, $db, $website, $team, $moduleinfo, $module, $template, $layout) {
    $htmlcode = "";
    $row1 = $db->website_info()->where("site", $website)->where("team", $team)->where("module", "GALLERY_IMAGE")->where("deleted",0);
    if ($siteinfo = $row1->fetch()) {
        //Lets breakdown the module infor to see what we have here. 
        $htmlcode = $htmlcode . ' Gallery Module Found';
        $moduledecoded = json_decode($moduleinfo);
        $htmlcode = $siteinfo['facelet_html'];
        $html = str_get_html($htmlcode);
        //Lets get the IMAGE tag and deal with it here
        $str = "";
        $row3 = $db->websites_template_facelets()->where("template", $template)->where("layout", $layout)->where("module", "GALLERY_IMAGE_FACET");
        //	echo $row3;

        if (!empty($moduledecoded->wfield5)) {
            //Lets modify the title to contain a 
            $anchorTag = '<a onclick="displayVideo(\'' . $moduledecoded->wfield5 . '\')" style="background-color: red;   color: white;   padding: 1em 1.5em;   text-decoration: none;   text-transform: uppercase;">Play Video</a>';
            $moduledecoded->title = '<p style="float:left;">'.$moduledecoded->title . '</p> <p style="float:right;">' . $anchorTag.'</p>';
        }
        if ($imagefacelet = $row3->fetch()) {

            $str = $imagefacelet ['htmlcode'];
            $str = str_replace("TAG_REPLACE", $moduledecoded->category, $str);
            $str = str_replace("IMAGE_REPLACE", $GLOBALS['imagespath'] . $moduledecoded->path, $str);
            $str = str_replace("CAPTION_REPLACE", $moduledecoded->title, $str);
            //	 $str  = str_replace('class="active"',"",$str);
        }
        //Lets insert the information into the html here  
        try {
            $element = $html->getElementById('#facelets');
            $element->innertext = $element->innertext . $str;
        } catch (Exception $e) {
            //	echo 'Message: ' .$e->getMessage();
        }

        //	echo $str;
        //Next lets get the Light box facets 
        $str1 = "";
        $row33 = $db->websites_template_facelets()->where("template", $template)->where("layout", $layout)->where("module", "GALLERY_IMAGE_FACET_LIGHTBOX");

        if ($imagefacelet1 = $row33->fetch()) {
            //	 	echo $imagefacelet; exit ;  	
            $str1 = $imagefacelet1['htmlcode'];
            $str1 = str_replace("LIGHT_BOX_REPLACE", $GLOBALS['imagespath'] . $moduledecoded->path, $str1);
            //$str1  =  str_replace("ACTIVE_REPLACE" ,"active",$str1); 
            $str1 = str_replace('carousel-item active', "carousel-item", $str1);
        }
        try {
            $element = $html->getElementById('#light_box_images');
            $element->innertext = $element->innertext . $str1;
        } catch (Exception $e) {
            //echo 'Message: ' .$e->getMessage();
        }

        //Lets deal with the counters here 
        $str11 = "";
        $row333 = $db->websites_template_facelets()->where("template", $template)->where("layout", $layout)->where("module", "GALLERY_IMAGE_FACET_LIGHTBOX_CAROUSEL");

        if ($imagefacelet11 = $row333->fetch()) {
            //		echo $imagefacelet; exit ;  	
            $str11 = $imagefacelet11['htmlcode'];
            $str11 = str_replace('class="active"', "", $str11);
        }
        try {
            $element = $html->getElementById('#light_box_count');
            $element->innertext = $element->innertext . $str11;
        } catch (Exception $e) {
            
        }


        $html = str_replace("FLIMAGEID", "fl" . $moduledecoded->foreignid, $html);
        $html = str_replace("CLIMAGEID", "cl" . $moduledecoded->foreignid, $html);
        $html = str_replace("IMAGEID", $moduledecoded->foreignid, $html);
        //		$html  = str_replace("POSITION" ,$moduledecoded->foreignid,$html); 
        $htmlcode = $html;
        $htmlcode = process_position_numbers($htmlcode);

        //From here we need to go through the images to make sure that each has gotten its own position number.
        //We update here 
        $data = array(
            'facelet_html' => $htmlcode,
        );

        $result = $row1->update($data);
        //	  var_dump ($htmlcode);
        //  exit(0);		
    }


    //		echo $htmlcode;
    return $htmlcode;
}

function process_save_gallery_video_html($app, $db, $website, $team, $moduleinfo, $module, $template, $layout) {
    $htmlcode = "";
    $row1 = $db->website_info()->where("site", $website)->where("team", $team)->where("module", "GALLERY_VIDEO");
    //echo $row1;
    if ($siteinfo = $row1->fetch()) {
        //Lets breakdown the module infor to see what we have here. 
        $htmlcode = $htmlcode . ' Gallery Module Found';
        $moduledecoded = json_decode($moduleinfo);
        $htmlcode = $siteinfo['facelet_html'];
        $html = str_get_html($htmlcode);
        //Lets get the IMAGE tag and deal with it here
        $str = "";
        $row3 = $db->websites_template_facelets()->where("template", $template)->where("layout", $layout)->where("module", "GALLERY_VIDEO_FACET");
        //	echo $row3;

        if ($imagefacelet = $row3->fetch()) {

            $str = $imagefacelet ['htmlcode'];
            $str = str_replace("TAG_REPLACE", $moduledecoded->category, $str);
            $str = str_replace("IMAGE_REPLACE", $GLOBALS['imagespath'] . $moduledecoded->path, $str);
            $str = str_replace("CAPTION_REPLACE", $moduledecoded->title, $str);
            $str = str_replace("VIDEO_URL", $moduledecoded->wfield5, $str);
            //	 $str  = str_replace('class="active"',"",$str);
        }
        //Lets insert the information into the html here  
        try {
            $element = $html->getElementById('#faceletsv');
            $element->innertext = $element->innertext . $str;
        } catch (Exception $e) {
            //	echo 'Message: ' .$e->getMessage();
        }

        //	echo $str;
        //Next lets get the Light box facets 
        $str1 = "";
        $row33 = $db->websites_template_facelets()->where("template", $template)->where("layout", $layout)->where("module", "GALLERY_VIDEO_FACET_LIGHTBOX");

        if ($imagefacelet1 = $row33->fetch()) {
            //	 	echo $imagefacelet; exit ;  	
            $str1 = $imagefacelet1['htmlcode'];
            $str1 = str_replace("LIGHT_BOX_REPLACE", $GLOBALS['imagespath'] . $moduledecoded->path, $str1);
            //$str1  =  str_replace("ACTIVE_REPLACE" ,"active",$str1); 
            $str1 = str_replace('carousel-item active', "carousel-item", $str1);
        }
        try {
            $element = $html->getElementById('#light_box_imagesv');
            $element->innertext = $element->innertext . $str1;
        } catch (Exception $e) {
            //echo 'Message: ' .$e->getMessage();
        }

        //Lets deal with the counters here 
        $str11 = "";
        $row333 = $db->websites_template_facelets()->where("template", $template)->where("layout", $layout)->where("module", "GALLERY_VIDEO_FACET_LIGHTBOX_CAROUSEL");

        if ($imagefacelet11 = $row333->fetch()) {
            //		echo $imagefacelet; exit ;  	
            $str11 = $imagefacelet11['htmlcode'];
            $str11 = str_replace('class="active"', "", $str11);
        }
        try {
            $element = $html->getElementById('#light_box_countv');
            $element->innertext = $element->innertext . $str11;
        } catch (Exception $e) {
            
        }


        $html = str_replace("FLIMAGEID", "fl" . $moduledecoded->foreignid, $html);
        $html = str_replace("CLIMAGEID", "cl" . $moduledecoded->foreignid, $html);
        $html = str_replace("IMAGEID", $moduledecoded->foreignid, $html);
        //		$html  = str_replace("POSITION" ,$moduledecoded->foreignid,$html); 
        $htmlcode = $html;
        $htmlcode = process_position_numbers_video_gallery($htmlcode);

        //From here we need to go through the images to make sure that each has gotten its own position number.
        //We update here 
        $data = array(
            'facelet_html' => $htmlcode,
        );

        $result = $row1->update($data);
        //	  var_dump ($htmlcode);
        //  exit(0);		
    }


    //		echo $htmlcode;
    return $htmlcode;
}

function process_contact_info_html($app, $db, $website, $team, $moduleinfo, $module) {
    $htmlcode = "";
    $row1 = $db->websites()->where("website_app_id", $website)->where("team", $team);
    if ($siteinfo = $row1->fetch()) {
        //Lets breakdown the module infor to see what we have here. 
        $moduledecoded = json_decode($moduleinfo);
        $template = $siteinfo['template'];
        //var_dump ($moduledecoded);
        //$layout    = 	$moduledecoded->layout;
        $layout = "layout1";


        $row2 = $db->websites_template_facelets()->where("template", $template)->where("layout", $layout)->where("module", $module);
        if ($facelet = $row2->fetch()) {

            //Lets get the data flowing here 
            $htmlcode = $facelet['htmlcode'];
            $html = str_get_html($htmlcode);


            try {
                $element = $html->getElementById('#cntaddress');
                $element->innertext = $moduledecoded->address;
            } catch (Exception $e) {
                //echo 'Message: ' .$e->getMessage();
            }

            try {
                $element = $html->getElementById('#cntphone');
                $element->innertext = $moduledecoded->contact;
            } catch (Exception $e) {
                //echo 'Message: ' .$e->getMessage();
            }

            try {
                $element = $html->getElementById('#cntemail');
                $element->innertext = $moduledecoded->email;
            } catch (Exception $e) {
                //echo 'Message: ' .$e->getMessage();
            }

            try {
                $element = $html->getElementById('#cnthours');
                $element->innertext = $moduledecoded->hours;
            } catch (Exception $e) {
                //echo 'Message: ' .$e->getMessage();
            }
            //Lets replace the placeholder of the background image. If it does not exist no problem.  


            $htmlcode = $html;
        }
    }

    return $htmlcode;
}

function process_landing_html($app, $db, $website, $team, $moduleinfo, $module) {
    $htmlcode = "";
    $row1 = $db->websites()->where("website_app_id", $website)->where("team", $team);
    if ($siteinfo = $row1->fetch()) {
        //Lets breakdown the module infor to see what we have here. 
        $moduledecoded = json_decode($moduleinfo);
        $template = $siteinfo['template'];
        $layout = $moduledecoded->layout;


        $row2 = $db->websites_template_facelets()->where("template", $template)->where("layout", $layout)->where("module", $module);
        if ($facelet = $row2->fetch()) {

            //Lets get the data flowing here 
            $htmlcode = $facelet['htmlcode'];
            $htmlcode = str_replace("LANDING_INFO_BG", 'https://cresterp.com/api/uploads/uploads/' . $moduledecoded->bgImage, $htmlcode);
            $htmlcode = str_replace("LANDING_INFO_YOUTUBE", $moduledecoded->bgYoutubeLink, $htmlcode);
            //Lets modify the htmlcode and save it allong with the other information. 
            $html = str_get_html($htmlcode);
            //$e->getElementById ( $id )
            try {
                $element = $html->getElementById('#landing_header1');
                $element->innertext = $moduledecoded->header1;
            } catch (Exception $e) {
                //echo 'Message: ' .$e->getMessage();
            }


            try {
                $element = $html->getElementById('#landing_header2');
                $element->innertext = $moduledecoded->header2;
            } catch (Exception $e) {
                //echo 'Message: ' .$e->getMessage();
            }

            //Lets replace the placeholder of the background image. If it does not exist no problem.  

            try {
                $element = $html->getElementById('#landing_description1');
                $element->innertext = $moduledecoded->description;
            } catch (Exception $e) {
                //echo 'Message: ' .$e->getMessage();
            }

            $htmlcode = $html;
        }
    }

    return $htmlcode;
}

function process_product_highlight_html($app, $db, $website, $team, $moduleinfo, $module) {
    $htmlcode = "";
    $row1 = $db->websites()->where("website_app_id", $website)->where("team", $team);
    if ($siteinfo = $row1->fetch()) {
        //Lets breakdown the module infor to see what we have here. 
        $moduledecoded = json_decode($moduleinfo);
        $template = $siteinfo['template'];
        $layout = $moduledecoded->layout;


        $row2 = $db->websites_template_facelets()->where("template", $template)->where("layout", $layout)->where("module", $module);
        if ($facelet = $row2->fetch()) {

            //Lets get the data flowing here 
            $htmlcode = $facelet['htmlcode'];
            $htmlcode = str_replace("PH_IMAGE", 'https://cresterp.com/api/uploads/uploads/' . $moduledecoded->bgImage, $htmlcode);

            $html = str_get_html($htmlcode);

            try {
                $element = $html->getElementById('#phmainheader');
                $element->innertext = $moduledecoded->mainheader;
            } catch (Exception $e) {
                
            }

            try {
                $element = $html->getElementById('#phdescription');
                $element->innertext = $moduledecoded->description;
            } catch (Exception $e) {
                
            }

            try {
                $element = $html->getElementById('#phheader1');
                $element->innertext = $moduledecoded->header1;
            } catch (Exception $e) {
                
            }

            try {
                $element = $html->getElementById('#phheader1description');
                $element->innertext = $moduledecoded->subtitle1;
            } catch (Exception $e) {
                
            }

            try {
                $element = $html->getElementById('#phheader2');
                $element->innertext = $moduledecoded->header2;
            } catch (Exception $e) {
                
            }

            try {
                $element = $html->getElementById('#phheader2description');
                $element->innertext = $moduledecoded->subtitle2;
            } catch (Exception $e) {
                
            }

            $htmlcode = $html;
        }
    }

    return $htmlcode;
}

function process_value_proposition_html($app, $db, $website, $team, $moduleinfo, $module) {
    $htmlcode = "";
    $row1 = $db->websites()->where("website_app_id", $website)->where("team", $team);
    if ($siteinfo = $row1->fetch()) {
        //Lets breakdown the module infor to see what we have here. 
        $moduledecoded = json_decode($moduleinfo);
        $template = $siteinfo['template'];
        $layout = $moduledecoded->layout;


        $row2 = $db->websites_template_facelets()->where("template", $template)->where("layout", $layout)->where("module", $module);
        if ($facelet = $row2->fetch()) {

            //Lets get the data flowing here 
            $htmlcode = $facelet['htmlcode'];
            //	 $htmlcode = str_replace("LANDING_INFO_BG",'https://cresterp.com/api/uploads/uploads/'.$moduledecoded->bgImage,$htmlcode);
            //Lets modify the htmlcode and save it allong with the other information. 
            $html = str_get_html($htmlcode);
            //$e->getElementById ( $id )
            try {
                $element = $html->getElementById('#vpmainheader');
                $element->innertext = $moduledecoded->mainheader;
            } catch (Exception $e) {
                //echo 'Message: ' .$e->getMessage();
            }


            try {
                $element = $html->getElementById('#vpmaindescription');
                $element->innertext = $moduledecoded->maindescription;
            } catch (Exception $e) {
                //echo 'Message: ' .$e->getMessage();
            }

            try {
                $element = $html->getElementById('#vpheader1');
                $element->innertext = $moduledecoded->header1;
            } catch (Exception $e) {
                //echo 'Message: ' .$e->getMessage();
            }

            try {
                $element = $html->getElementById('#vpsubtitle1');
                $element->innertext = $moduledecoded->title1;
            } catch (Exception $e) {
                //echo 'Message: ' .$e->getMessage();
            }

            try {
                $element = $html->getElementById('#vpdescription1');
                $element->innertext = $moduledecoded->description1;
            } catch (Exception $e) {
                //echo 'Message: ' .$e->getMessage();
            }

            try {
                $element = $html->getElementById('#vpheader2');
                $element->innertext = $moduledecoded->header2;
            } catch (Exception $e) {
                //echo 'Message: ' .$e->getMessage();
            }

            try {
                $element = $html->getElementById('#vpsubtitle2');
                $element->innertext = $moduledecoded->title2;
            } catch (Exception $e) {
                //echo 'Message: ' .$e->getMessage();
            }

            try {
                $element = $html->getElementById('#vpdescription2');
                $element->innertext = $moduledecoded->description2;
            } catch (Exception $e) {
                //echo 'Message: ' .$e->getMessage();
            }

            try {
                $element = $html->getElementById('#vpheader3');
                $element->innertext = $moduledecoded->header3;
            } catch (Exception $e) {
                //echo 'Message: ' .$e->getMessage();
            }

            try {
                $element = $html->getElementById('#vpsubtitle3');
                $element->innertext = $moduledecoded->title3;
            } catch (Exception $e) {
                //echo 'Message: ' .$e->getMessage();
            }

            try {
                $element = $html->getElementById('#vpdescription3');
                $element->innertext = $moduledecoded->description3;
            } catch (Exception $e) {
                //echo 'Message: ' .$e->getMessage();
            }

            //Lets replace the placeholder of the background image. If it does not exist no problem.  



            $htmlcode = $html;
        }
    }

    return $htmlcode;
}

function save_module_contact_info($app, $db, $website, $team, $moduleinfo, $module) {

    $htmlcode = process_contact_info_html($app, $db, $website, $team, $moduleinfo, $module);
    $data = array(
        'site' => $website,
        'team' => $team,
        'module' => $module,
        'module_data' => $moduleinfo,
        'facelet_html' => $htmlcode,
        'display_position' => 20,
    );
    //Lets save to the database here 
    $db->website_info->insert($data);

    //We must get the contact info as well and process it here. 
}

function update_module_contact_info($app, $db, $website, $team, $moduleid, $moduleinfo, $module) {

    $htmlcode = process_contact_info_html($app, $db, $website, $team, $moduleinfo, $module);
    $data = array(
        'module_data' => $moduleinfo,
        'facelet_html' => $htmlcode,
    );
    $row = $db->website_info()->where("id", $moduleid);
    // echo $row;
    if ($row->fetch()) {
        $result = $row->update($data);
    }
}

function process_achievements_html($app, $db, $website, $team, $moduleinfo, $module) {
    $htmlcode = "";
    $row1 = $db->websites()->where("website_app_id", $website)->where("team", $team);
    if ($siteinfo = $row1->fetch()) {
        //Lets breakdown the module infor to see what we have here. 
        $moduledecoded = json_decode($moduleinfo);
        $template = $siteinfo['template'];
        $layout = $moduledecoded->layout;


        $row2 = $db->websites_template_facelets()->where("template", $template)->where("layout", $layout)->where("module", $module);
        if ($facelet = $row2->fetch()) {

            //Lets get the data flowing here 
            $htmlcode = $facelet['htmlcode'];
            //	 $htmlcode = str_replace("LANDING_INFO_BG",'https://cresterp.com/api/uploads/uploads/'.$moduledecoded->bgImage,$htmlcode);
            //Lets modify the htmlcode and save it allong with the other information. 
            $html = str_get_html($htmlcode);
            //$e->getElementById ( $id )
            try {
                $element = $html->getElementById('#acmainheader');
                $element->innertext = $moduledecoded->mainheader;
            } catch (Exception $e) {
                //echo 'Message: ' .$e->getMessage();
            }


            try {
                $element = $html->getElementById('#acmaindescription');
                $element->innertext = $moduledecoded->maindescription;
            } catch (Exception $e) {
                //echo 'Message: ' .$e->getMessage();
            }

            try {
                $element = $html->getElementById('#acheader1');
                $element->innertext = $moduledecoded->header1;
            } catch (Exception $e) {
                //echo 'Message: ' .$e->getMessage();
            }

            try {
                $element = $html->getElementById('#acsubtitle1');
                $element->innertext = $moduledecoded->title1;
            } catch (Exception $e) {
                //echo 'Message: ' .$e->getMessage();
            }

            try {
                $element = $html->getElementById('#acdescription1');
                $element->innertext = $moduledecoded->description1;
            } catch (Exception $e) {
                //echo 'Message: ' .$e->getMessage();
            }

            try {
                $element = $html->getElementById('#acheader2');
                $element->innertext = $moduledecoded->header2;
            } catch (Exception $e) {
                //echo 'Message: ' .$e->getMessage();
            }

            try {
                $element = $html->getElementById('#acsubtitle2');
                $element->innertext = $moduledecoded->title2;
            } catch (Exception $e) {
                //echo 'Message: ' .$e->getMessage();
            }

            try {
                $element = $html->getElementById('#acdescription2');
                $element->innertext = $moduledecoded->description2;
            } catch (Exception $e) {
                //echo 'Message: ' .$e->getMessage();
            }

            try {
                $element = $html->getElementById('#acheader3');
                $element->innertext = $moduledecoded->header3;
            } catch (Exception $e) {
                //echo 'Message: ' .$e->getMessage();
            }

            try {
                $element = $html->getElementById('#acsubtitle3');
                $element->innertext = $moduledecoded->title3;
            } catch (Exception $e) {
                //echo 'Message: ' .$e->getMessage();
            }

            try {
                $element = $html->getElementById('#acdescription3');
                $element->innertext = $moduledecoded->description3;
            } catch (Exception $e) {
                //echo 'Message: ' .$e->getMessage();
            }

            //Lets replace the placeholder of the background image. If it does not exist no problem.  



            $htmlcode = $html;
        }
    }

    return $htmlcode;
}

function save_module_landing_info($app, $db, $website, $team, $moduleinfo, $module) {

    //Lets find what template its been operating on totangira ipapo 

    $htmlcode = process_landing_html($app, $db, $website, $team, $moduleinfo, $module);
    //	echo 'html tadzoka nei '.$htmlcode;

    $data = array(
        'site' => $website,
        'team' => $team,
        'module' => $module,
        'module_data' => $moduleinfo,
        'facelet_html' => $htmlcode,
        'display_position' => 1,
    );
    //Lets save to the database here 
    $rezo = $db->website_info->insert($data);
    //	echo $rezo ;
}

function update_module_landing_info($app, $db, $moduleid, $moduleinfo, $website, $team, $module) {

    $htmlcode = process_landing_html($app, $db, $website, $team, $moduleinfo, $module);
    $data = array(
        'module_data' => $moduleinfo,
        'facelet_html' => $htmlcode,
    );
    $row = $db->website_info()->where("id", $moduleid);
    //	 echo $row;

    if ($row->fetch()) {
        $result = $row->update($data);
        //	  echo $result;
    } else {
        //echo 'Cant find pakuUpdate'; 			
    }
}

function save_module_gallery_video($app, $db, $website, $team, $moduleinfo, $module) {

    //Lets find what template its been operating on totangira ipapo 

    $htmlcode = process_save_video_gallery_html($app, $db, $website, $team, $moduleinfo, $module);
    //	echo 'html tadzoka nei '.$htmlcode;

    $data = array(
        'site' => $website,
        'team' => $team,
        'module' => $module,
        'module_data' => $moduleinfo,
        'facelet_html' => $htmlcode,
        'display_position' => 6,
    );
    //Lets save to the database here 
    $rezo = $db->website_info->insert($data);
    //	echo $rezo ;
}

function update_module_video_gallery_facelet($app, $db, $moduleid, $moduleinfo, $website, $team, $module) {

    $result = "";
    $row1 = $db->websites()->where("website_app_id", $website)->where("team", $team);

    if ($siteinfo = $row1->fetch()) {
        //Lets breakdown the module infor to see what we have here. 

        $moduledecoded = json_decode($moduleinfo);
        $template = $siteinfo['template'];
        $layout = 'layout1';
        $result = process_save_gallery_video_html($app, $db, $website, $team, $moduleinfo, $module, $template, $layout);
    }
    return $result;
}

function save_module_gallery_image($app, $db, $website, $team, $moduleinfo, $module) {

    //Lets find what template its been operating on totangira ipapo 

    $htmlcode = process_save_gallery_html($app, $db, $website, $team, $moduleinfo, $module);
    //	echo 'html tadzoka nei '.$htmlcode;

    $data = array(
        'site' => $website,
        'team' => $team,
        'module' => $module,
        'module_data' => $moduleinfo,
        'facelet_html' => $htmlcode,
        'display_position' => 5,
    );
    //Lets save to the database here 
    $rezo = $db->website_info->insert($data);
    //	echo $rezo ;
}

function update_module_image_gallery_facelet($app, $db, $moduleid, $moduleinfo, $website, $team, $module) {

    $result = "";
    $row1 = $db->websites()->where("website_app_id", $website)->where("team", $team);

    if ($siteinfo = $row1->fetch()) {
        //Lets breakdown the module infor to see what we have here. 

        $moduledecoded = json_decode($moduleinfo);
        $template = $siteinfo['template'];
        $layout = 'layout1';
        $result = process_save_gallery_image_html($app, $db, $website, $team, $moduleinfo, $module, $template, $layout);
    }
    return $result;
}

function save_module_value_proposition($app, $db, $website, $team, $moduleinfo, $module) {

    //Lets find what template its been operating on totangira ipapo 

    $htmlcode = process_value_proposition_html($app, $db, $website, $team, $moduleinfo, $module);
    //	echo 'html tadzoka nei '.$htmlcode;

    $data = array(
        'site' => $website,
        'team' => $team,
        'module' => $module,
        'module_data' => $moduleinfo,
        'facelet_html' => $htmlcode,
        'display_position' => 2,
    );
    //Lets save to the database here 
    $rezo = $db->website_info->insert($data);
    //	echo $rezo ;
}

function update_module_value_proposition($app, $db, $moduleid, $moduleinfo, $website, $team, $module) {

    $htmlcode = process_value_proposition_html($app, $db, $website, $team, $moduleinfo, $module);
    $data = array(
        'module_data' => $moduleinfo,
        'facelet_html' => $htmlcode,
    );
    $row = $db->website_info()->where("id", $moduleid);
    //	 echo $row;

    if ($row->fetch()) {
        $result = $row->update($data);
        //	  echo $result;
    } else {
        //echo 'Cant find pakuUpdate'; 			
    }
}

function save_module_achievements($app, $db, $website, $team, $moduleinfo, $module) {

    //Lets find what template its been operating on totangira ipapo 

    $htmlcode = process_achievements_html($app, $db, $website, $team, $moduleinfo, $module);
    //	echo 'html tadzoka nei '.$htmlcode;

    $data = array(
        'site' => $website,
        'team' => $team,
        'module' => $module,
        'module_data' => $moduleinfo,
        'facelet_html' => $htmlcode,
        'display_position' => 2,
    );
    //Lets save to the database here 
    $rezo = $db->website_info->insert($data);
    //	echo $rezo ;
}

function update_module_achievements($app, $db, $moduleid, $moduleinfo, $website, $team, $module) {

    $htmlcode = process_achievements_html($app, $db, $website, $team, $moduleinfo, $module);
    $data = array(
        'module_data' => $moduleinfo,
        'facelet_html' => $htmlcode,
    );
    $row = $db->website_info()->where("id", $moduleid);
    //	 echo $row;

    if ($row->fetch()) {
        $result = $row->update($data);
        //	  echo $result;
    } else {
        //echo 'Cant find pakuUpdate'; 			
    }
}

function save_module_product_highlight($app, $db, $website, $team, $moduleinfo, $module) {

    //Lets find what template its been operating on totangira ipapo 

    $htmlcode = process_product_highlight_html($app, $db, $website, $team, $moduleinfo, $module);
    //	echo 'html tadzoka nei '.$htmlcode;

    $data = array(
        'site' => $website,
        'team' => $team,
        'module' => $module,
        'module_data' => $moduleinfo,
        'facelet_html' => $htmlcode,
        'display_position' => 4,
    );
    //Lets save to the database here 
    $rezo = $db->website_info->insert($data);
    //	echo $rezo ;
}

function update_module_product_highlight($app, $db, $moduleid, $moduleinfo, $website, $team, $module) {

    $htmlcode = process_product_highlight_html($app, $db, $website, $team, $moduleinfo, $module);
    $data = array(
        'module_data' => $moduleinfo,
        'facelet_html' => $htmlcode,
    );
    $row = $db->website_info()->where("id", $moduleid);
    //	 echo $row;

    if ($row->fetch()) {
        $result = $row->update($data);
        //	  echo $result;
    } else {
        //echo 'Cant find pakuUpdate'; 			
    }
}
