<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 * 
 */

$app->post('/join_promotion', function() use( $app, $db ) {
    $app->response()->header("Content-Type", "application/json");

    $promotioncode = $app->request()->post('promotion');
    $team = $app->request()->post('team');
    $success = 0;
    $message = "";
    $currentDate = date("Y-m-d");
    //Lets look for the referal code that was used when they joined on someone. 
    $row2 = $db->referals()->where("owner", $promotioncode)->where("referalteam", $team);

    if ($s2 = $row2->fetch()) {
        $program = $s2['program'];
        $generatedReferal = $s2['referal'];
        $parent = $s2['ownerteam'];
        //Next check if the program is still running 
        $row = $db->referal_programs()->where("code", $program)->where("expires >=" . $currentDate);
        if ($s11 = $row->fetch()) {

            //Lets check of the person had already entered in this competition 
            $row22 = $db->referals()->where("program", $program)->where("ownerteam", $team);
            if ($s111 = $row22->fetch()) {
                $message = "Looks like you have already joined this promotion";
            } else {

                $description = $s11['description'];

                //Here we need to notify the person who is joining with the promotion details, terms and references.
                $data = array('NAME' => "Promotion Joining", 'TEAM' => $team, 'MESSAGE' => 'Promotion Details: ' . $description . ' SHARE COUPON: ' . $generatedReferal
                    , 'MESSAGETYPE' => "PROMOTION", 'REFERENCE' => $promotioncode);
                $result = $db->prospects->insert($data);

                //We need to have a record of their own here in the referals table 
                $ref = array('program' => $program
                    , 'owner' => $generatedReferal
                    , 'ownerteam' => $team
                    , 'referal' => "JOINED"
                    , 'referalteam' => $parent
                    , 'referaltype' => 'PROMOTION');

                $db->referals->insert($ref);
                $message = "You have successfully joined a promotion. Check your inbox for more details";
                $success = 1;
            }
        } else {

            $message = "Promotion Expired";
        }
    } else {
        $message = "Reference code not found";
        /* Here lets allow the person to join. by looking for the parent of the code that is 
         * to say someone who has the code and joined as a referal. 
         */
        $row3 = $db->referals()->where("owner", $promotioncode)->where("referal", "JOINED");
        if ($s3 = $row3->fetch()) {
            $program = $s3['program'];
            $row12 = $db->referal_programs()->where("code", $program)->where("expires >=" . $currentDate);
            if ($s121 = $row12->fetch()) {
                //We add to the referals table and then alert that we have joined
                $program = $s3['program'];
                $description = $s121['description'];
                $generatedReferal = generateReferalCode("");
                $parent = $s3['ownerteam'];
                $ref = array('program' => $program
                    , 'owner' => $generatedReferal
                    , 'ownerteam' => $team
                    , 'referal' => "JOINED"
                    , 'referalteam' => $parent
                    , 'referaltype' => 'PROMOTION');

                $db->referals->insert($ref);
                $message = "You have successfully joined a promotion. Check your inbox for more details";
                $success = 1;

                //Here we need to notify the person who is joining with the promotion details, terms and references.
                $data = array('NAME' => "Promotion Joining", 'TEAM' => $team, 'MESSAGE' => 'Promotion Details: ' . $description . ' your SHARE COUPON IS: ' . $generatedReferal
                    , 'MESSAGETYPE' => "PROMOTION", 'REFERENCE' => $generatedReferal);
                $result = $db->prospects->insert($data);
            } else {
                
            }
        }
    }

    $response = array('success' => $success, 'message' => $message);
    echo json_encode($response);
});

$app->post('/redeem', function() use( $app, $db ) {
    $app->response()->header("Content-Type", "application/json");
    $promotioncode = $app->request()->post('promotion');
    $team = $app->request()->post('team');
    $message = $app->request()->post('message');
    $name = $app->request()->post('name');
    $success = 0;
    $message = "";


//Lets find out who owns the code. 
    $row1 = $db->referals()->where("owner", $promotioncode);
    if ($s1 = $row1->fetch()) {

        //We need to find if the program is still running and valid. 
        $program = $s1['program'];
        $ownerteam = $s1['ownerteam'];
        $owner = $s1['owner'];
        $currentDate = date("Y-m-d");
        $newreferal = generateReferalCode("");

        $row = $db->referal_programs()->where("code", $program)->where("expires >=" . $currentDate);
        if ($s11 = $row->fetch()) {
            //First check if the promotion has been redeemed already 
            $row2 = $db->referals()->where("owner", $promotioncode)->where("referalteam", $team)->where("program", $program);

            if ($s2 = $row2->fetch()) {

                $message = "You have already redeemed this promotion using this same reference";
            } else {

                $row22 = $db->referals()->where("referalteam", $team)->where("program", $program);

                if ($s22 = $row22->fetch()) {

                    $message = "You have already redeemed this promotion using a different reference";
                } else {
                    //Now that its certified and its running. Next we want to save the referal 
                    $description = $s11['description'];
                    $referalMessage = $s11['referalmessage'];
                    $ref = array('program' => $program
                        , 'owner' => $owner
                        , 'ownerteam' => $ownerteam
                        , 'referal' => $newreferal
                        , 'referalteam' => $team);
                    $db->referals->insert($ref);

//We want to notify the person who refered us of this
                    $data = array('NAME' => $name, 'TEAM' => $ownerteam, 'MESSAGE' => $message . 'Promotion Details: ' . $description
                        , 'MESSAGETYPE' => "PROMOTION", 'REFERENCE' => $promotioncode);
                    $result = $db->prospects->insert($data);

//Next the person who has made redepmtion.
                    $data1 = array('NAME' => "Promotion/Discount Reedemed", 'TEAM' => $team, 'MESSAGE' => $referalMessage
                        , 'MESSAGETYPE' => "PROMOTION", 'REFERENCE' => $promotioncode);
                    $result1 = $db->prospects->insert($data1);

                    $message = "Promotion/coupon successfully redeemed";
                    $success = 1;
                }
            }
        } else {
            $message = "Promotion not found. It probably expired";
        }
    } else {

        $message = "Promotion code not found";
    }


    $response = array('success' => $success, 'message' => $message);
    echo json_encode($response);
});

function generateReferalCode($tablename) {
    $success = false;
    $refer = substr(md5(uniqid(rand(1, 6))), 0, 8);
    /* if ($tablename == "REFER_PROGRAM") {
      //check if there
      $row1 = $db->referals()->where("referal", $id);
      if ($s1 = $row1->fetch()) {

      }
      } */
    return $refer;
}
