// chatbox.js

// CSS styles for the chatbox, added dynamically
var style = document.createElement('style');
        style.innerHTML = `
    html, body {
        background: #efefef;
        height: 100%;
    }
    body, div, p, a, h1, h2, h3, h4, h5, h6, span {
        margin: 0;
        padding: 0;
    }
    .chat-box {
        display: none;
        position: fixed;
        bottom: 0;
        right: 30px;
        /*width: 380px;*/
        width: 320px;
        height: 500px;
        background: #fff;
        box-shadow: 0 5px 35px rgba(0, 0, 0, 0.15);
        border-radius: 10px 10px 0 0;
        overflow: hidden;
        z-index: 999;
        font-size: 14px; /* Reduced font size */
    }
    .chat-box-header {
        background: #1e90ff;
        color: white;
        padding: 15px;
        text-align: center;
        font-size: 18px;
        font-weight: bold;
        border-bottom: 1px solid #eee;
        position: relative;
    }
    .chat-box-body {
        height: 280px; /* Adjusted height to accommodate quick buttons */
        overflow-y: auto;
    }
    .chat-box-body .chat-logs {
        padding: 10px;
    }
    .chat-box-body .chat-msg {
        margin-bottom: 15px;
    }
    .chat-box-body .chat-msg.self .msg-avatar {
        float: right;
    }
    .chat-box-body .chat-msg.user .msg-avatar {
        float: left;
    }
    .chat-box-body .chat-msg .msg-avatar i {
        font-size: 30px;
    }
    .chat-box-body .chat-msg .cm-msg-text {
        display: inline-block;
        max-width: 80%;
        padding: 10px;
        border-radius: 20px;
        background: #f1f0f0;
    }
    .chat-box-body .chat-msg.self .cm-msg-text {
        background: #1e90ff;
        color: white;
    }
    .chat-box-body .chat-msg.user .cm-msg-text {
        background: #e1e1e1;
    }
    .chat-input {
        padding: 10px;
        background: #f5f5f5;
        display: flex;
    }
    .chat-input input[type="text"] {
        flex: 1;
        border: none;
        padding: 10px;
        border-radius: 5px;
        margin-right: 5px;
    }
    .chat-input button {
        border: none;
        background: #1e90ff;
        color: white;
        padding: 10px 15px;
        border-radius: 5px;
        cursor: pointer;
        display: flex;
        align-items: center;
    }
    #chat-circle {
        position: fixed;
        bottom: 30px;
        right: 30px;
        background: #1e90ff;
        width: 60px;
        height: 60px;
        border-radius: 50%;
        text-align: center;
        line-height: 60px;
        color: white;
        font-size: 24px;
        cursor: pointer;
        z-index: 999;
    }
    #chat-circle i {
        line-height: 60px;
    }
    .btn {
        border: none;
        background: none;
    }
    .material-icons {
        font-family: 'Material Icons';
    }
    .quick-buttons {
        display: flex;
        justify-content: space-around;
        padding: 10px;
        background: #f5f5f5;
        border-bottom: 1px solid #eee;
    }
    .quick-button {
        background: #1e90ff;
        color: white;
        padding: 5px 10px;
        border-radius: 5px;
        cursor: pointer;
        font-size: 12px; /* Adjusted for the quick buttons */
    }
    @keyframes scale {
        from { transform: scale(0); }
        to { transform: scale(1); }
    }
    .scale {
        animation: scale 0.3s;
    }
`;
        document.head.appendChild(style);
// jQuery inclusion if not already present
        if (typeof jQuery === 'undefined') {
var script = document.createElement('script');
        script.src = "https://code.jquery.com/jquery-3.6.0.min.js";
        script.onload = function() { initChatBox(); };
        document.head.appendChild(script);
        } else {
initChatBox();
        }

// Initialize chatbox functionality
function initChatBox() {
$(function() {
var INDEX = 0;
        $("#chat-submit").click(function(e) {
e.preventDefault();
        var msg = $("#chat-input").val();
        if (msg.trim() == '') {
return false;
}
generate_message(msg, 'self');
        setTimeout(function() {
        generate_message("This is a simulated response", 'user');
        }, 1000);
});
        function generate_message(msg, type) {
        INDEX++;
                var avatar = (type === 'self') ? "<i class='material-icons'>person</i>" : "<i class='material-icons'>smart_toy</i>";
                var str = "";
                str += "<div id='cm-msg-" + INDEX + "' class='chat-msg " + type + "'>";
                str += "  <span class='msg-avatar'>" + avatar + "</span>";
                str += "  <div class='cm-msg-text'>";
                str += msg;
                str += "  </div>";
                str += "</div>";
                $(".chat-logs").append(str);
                $("#cm-msg-" + INDEX).hide().fadeIn(300);
                if (type == 'self') {
        $("#chat-input").val('');
        }
        $(".chat-logs").stop().animate({ scrollTop: $(".chat-logs")[0].scrollHeight }, 1000);
        }

// Quick launch button click handler
$(document).on('click', '.quick-button', function() {
var text = $(this).text();
        generate_message(text, 'self');
        if (text === "Menu") {
setTimeout(function() {
showMenuOptions();
}, 500);
} else {
setTimeout(function() {
generate_message("Processing: " + text, 'user');
}, 1000);
}
});
        // Display submenu options when 'Menu' is clicked
                function showMenuOptions() {
                var menuOptions = `
                <div class="quick-buttons">
                    <div class="quick-button">Car Tracking Service</div>
                    <div class="quick-button">Book a Car</div>
                    <div class="quick-button">Talk to a human</div>
                </div>
            `;
                        $(".chat-logs").append(menuOptions);
                        $(".chat-logs").stop().animate({ scrollTop: $(".chat-logs")[0].scrollHeight }, 1000);
                }

        $("#chat-circle").click(function() {
        $("#chat-circle").toggle('scale');
                $(".chat-box").toggle('scale');
        });
                $(".chat-box-toggle").click(function() {
        $("#chat-circle").toggle('scale');
                $(".chat-box").toggle('scale');
        });
        });
        }

// Append the HTML structure for the chatbox to the body
document.body.insertAdjacentHTML('beforeend', `
    <div id="chat-circle" class="btn btn-raised">
        <div id="chat-overlay"></div>
        <i class="material-icons">smart_toy</i> <!-- Changed to bot icon -->
    </div>
    <div class="chat-box">
        <div class="chat-box-header">
            ChatBot
            <span class="chat-box-toggle"><i class="material-icons">close</i></span>
        </div>
        <div class="quick-buttons">
            <div class="quick-button">Book a Car Now</div>
            <div class="quick-button">Whatsapp us</div>
            <div class="quick-button">Our Blog</div>
            <div class="quick-button">Menu</div>
        </div>
        <div class="chat-box-body">
            <div class="chat-box-overlay"></div>
            <div class="chat-logs"></div>
        </div>
        <div class="chat-input">
            <form>
                <input type="text" id="chat-input" placeholder="Send a message..."/>
                <button type="submit" class="chat-submit" id="chat-submit"><i class="material-icons">send</i></button>
            </form>
        </div>
    </div>
`);
