// chat-window.js

// Function to initialize the chat window
function initializeChatWindow() {
  // Create a container div for the chat window
  const chatContainer = document.createElement('div');
  chatContainer.id = 'chat-container';
  chatContainer.style.position = 'fixed';
  chatContainer.style.bottom = '20px';
  chatContainer.style.right = '20px';
  chatContainer.style.width = '300px';
  chatContainer.style.height = '400px';
  chatContainer.style.border = '1px solid #ccc';
  chatContainer.style.background = '#fff';
  chatContainer.style.boxShadow = '0 4px 8px rgba(0, 0, 0, 0.1)';
  chatContainer.style.zIndex = '1000';

  // Create the chat interface (simple example)
  chatContainer.innerHTML = `
    <div style="padding: 10px; border-bottom: 1px solid #ccc; background: #f5f5f5;">ChatGPT</div>
    <div id="chat-content" style="height: calc(100% - 80px); overflow-y: auto; padding: 10px;"></div>
    <input id="chat-input" type="text" style="width: calc(100% - 20px); padding: 10px; border: 1px solid #ccc;"/>
  `;

  // Append the chat container to the body
  document.body.appendChild(chatContainer);

  // Add event listener for input (simple chat interaction)
  document.getElementById('chat-input').addEventListener('keypress', function (e) {
    if (e.key === 'Enter') {
      const userInput = e.target.value;
      if (userInput) {
        const chatContent = document.getElementById('chat-content');
        chatContent.innerHTML += `<div>User: ${userInput}</div>`;
        e.target.value = '';
        // Here you would add the ChatGPT interaction
        chatContent.innerHTML += `<div>ChatGPT: Response goes here...</div>`;
      }
    }
  });
}

// Initialize the chat window when this script is loaded
initializeChatWindow();
