<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Multi-Step Car Rental Booking Form</title>
    <!-- Bootstrap CSS -->
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <!-- Custom CSS -->
    <style>
        .step {
            display: none;
        }
        .step.active {
            display: block;
        }
        .step-btns {
            display: flex;
            justify-content: space-between;
        }
    </style>
</head>
<body>
    <div class="container mt-5">
        <h2 class="mb-4">Car Rental Booking Form</h2>
        <form id="bookingForm">
            <!-- Step 1: Personal Information -->
            <div class="step active">
                <h4>Personal Information</h4>
                <div class="form-row">
                    <div class="form-group col-md-6">
                        <label for="fullName">Full Name</label>
                        <input type="text" class="form-control" id="fullName" placeholder="Enter your full name" required>
                    </div>
                    <div class="form-group col-md-6">
                        <label for="email">Email Address</label>
                        <input type="email" class="form-control" id="email" placeholder="Enter your email address" required>
                    </div>
                </div>
                <div class="form-row">
                    <div class="form-group col-md-6">
                        <label for="phone">Phone Number</label>
                        <input type="tel" class="form-control" id="phone" placeholder="Enter your phone number" required>
                    </div>
                    <div class="form-group col-md-6">
                        <label for="address">Address</label>
                        <input type="text" class="form-control" id="address" placeholder="Enter your address" required>
                    </div>
                </div>
                <div class="form-row">
                    <div class="form-group col-md-4">
                        <label for="city">City</label>
                        <input type="text" class="form-control" id="city" placeholder="City" required>
                    </div>
                    <div class="form-group col-md-4">
                        <label for="state">State</label>
                        <input type="text" class="form-control" id="state" placeholder="State" required>
                    </div>
                    <div class="form-group col-md-4">
                        <label for="zip">Zip Code</label>
                        <input type="text" class="form-control" id="zip" placeholder="Zip Code" required>
                    </div>
                </div>
                <div class="step-btns">
                    <button type="button" class="btn btn-primary next-step">Next</button>
                </div>
            </div>

            <!-- Step 2: Rental Details -->
            <div class="step">
                <h4>Rental Details</h4>
                <div class="form-row">
                    <div class="form-group col-md-6">
                        <label for="pickupLocation">Pick-up Location</label>
                        <input type="text" class="form-control" id="pickupLocation" placeholder="Enter pick-up location" required>
                    </div>
                    <div class="form-group col-md-6">
                        <label for="dropoffLocation">Drop-off Location</label>
                        <input type="text" class="form-control" id="dropoffLocation" placeholder="Enter drop-off location" required>
                    </div>
                </div>
                <div class="form-row">
                    <div class="form-group col-md-6">
                        <label for="pickupDate">Pick-up Date and Time</label>
                        <input type="datetime-local" class="form-control" id="pickupDate" required>
                    </div>
                    <div class="form-group col-md-6">
                        <label for="dropoffDate">Drop-off Date and Time</label>
                        <input type="datetime-local" class="form-control" id="dropoffDate" required>
                    </div>
                </div>
                <div class="form-row">
                    <div class="form-group col-md-6">
                        <label for="carType">Car Type</label>
                        <select class="form-control" id="carType" required>
                            <option>Sedan</option>
                            <option>SUV</option>
                            <option>Truck</option>
                            <option>Van</option>
                            <option>Convertible</option>
                            <option>Other</option>
                        </select>
                    </div>
                    <div class="form-group col-md-6">
                        <label for="passengers">Number of Passengers</label>
                        <input type="number" class="form-control" id="passengers" placeholder="Enter number of passengers" required>
                    </div>
                </div>
                <div class="form-group">
                    <label for="requests">Additional Requests</label>
                    <textarea class="form-control" id="requests" rows="3" placeholder="Enter any additional requests (e.g., child seat, GPS)"></textarea>
                </div>
                <div class="step-btns">
                    <button type="button" class="btn btn-secondary prev-step">Previous</button>
                    <button type="button" class="btn btn-primary next-step">Next</button>
                </div>
            </div>

            <!-- Step 3: Payment Information -->
            <div class="step">
                <h4>Payment Information</h4>
                <div class="form-row">
                    <div class="form-group col-md-6">
                        <label for="cardNumber">Credit Card Number</label>
                        <input type="text" class="form-control" id="cardNumber" placeholder="Enter your credit card number" required>
                    </div>
                    <div class="form-group col-md-3">
                        <label for="expiryDate">Expiration Date</label>
                        <input type="month" class="form-control" id="expiryDate" required>
                    </div>
                    <div class="form-group col-md-3">
                        <label for="cvv">CVV</label>
                        <input type="text" class="form-control" id="cvv" placeholder="CVV" required>
                    </div>
                </div>
                <div class="form-group">
                    <label for="cardName">Name on Card</label>
                    <input type="text" class="form-control" id="cardName" placeholder="Enter name as it appears on the card" required>
                </div>
                <div class="step-btns">
                    <button type="button" class="btn btn-secondary prev-step">Previous</button>
                    <button type="button" class="btn btn-primary next-step">Next</button>
                </div>
            </div>

            <!-- Step 4: Driver's Information -->
            <div class="step">
                <h4>Driver's Information</h4>
                <div class="form-row">
                    <div class="form-group col-md-4">
                        <label for="licenseNumber">Driver’s License Number</label>
                        <input type="text" class="form-control" id="licenseNumber" placeholder="Enter your driver’s license number" required>
                    </div>
                    <div class="form-group col-md-4">
                        <label for="issuingState">Issuing State/Country</label>
                        <input type="text" class="form-control" id="issuingState" placeholder="Enter the issuing state or country" required>
                    </div>
                    <div class="form-group col-md-4">
                        <label for="dob">Date of Birth</label>
                        <input type="date" class="form-control" id="dob" required>
                    </div>
                </div>
                <div class="step-btns">
                    <button type="button" class="btn btn-secondary prev-step">Previous</button>
                    <button type="button" class="btn btn-primary next-step">Next</button>
                </div>
            </div>

            <!-- Step 5: Additional Options and Review -->
            <div class="step">
                <h4>Additional Options</h4>
                <div class="form-group">
                    <label for="insurance">Insurance Options</label>
                    <select class="form-control" id="insurance" required>
                        <option>Basic Insurance</option>
                        <option>Premium Insurance</option>
                        <option>No Insurance</option>
                    </select>
                </div>
                <div class="form-group">
                    <label for="promoCode">Promotional Code</label>
                    <input type="text" class="form-control" id="promoCode" placeholder="Enter any promotional code or coupon">
                </div>
                <div class="step-btns">
                    <button type="button" class="btn btn-secondary prev-step">Previous</button>
                    <button type="submit" class="btn btn-success">Submit</button>
                </div>
            </div>
        </form>
    </div>
    
    <!-- Bootstrap JS and dependencies -->
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.2/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>

    <!-- Custom JS for handling form steps -->
    <script>
        $(document).ready(function() {
            var currentStep = 0;
            var steps = $(".step");
            
            function showStep(stepIndex) {
                steps.removeClass("active");
                $(steps[stepIndex]).addClass("active");
            }

            $(".next-step").click(function() {
                if (currentStep < steps.length - 1) {
                    currentStep++;
                    showStep(currentStep);
                }
            });

            $(".prev-step").click(function() {
                if (currentStep > 0) {
                    currentStep--;
                    showStep(currentStep);
                }
            });

            // Show the first step initially
            showStep(currentStep);
        });
    </script>
</body>
</html>
