<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>AI Chat Assistant</title>
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <style>
        .chat-container {
            position: fixed;
            bottom: 10px;
            right: 10px;
            width: 300px;
            max-height: 400px;
            border: 1px solid #ccc;
            border-radius: 10px;
            background-color: white;
            box-shadow: 0px 0px 10px rgba(0, 0, 0, 0.1);
        }

        .chat-header {
            padding: 10px;
            background: #007bff;
            color: white;
            text-align: center;
            cursor: pointer;
        }

        .chat-body {
            display: none;
            padding: 10px;
            height: 300px;
            overflow-y: auto;
            background: #f1f1f1;
        }

        .chat-footer {
            display: none;
            padding: 10px;
            background: #f1f1f1;
        }

        .chat-message {
            margin-bottom: 15px;
        }

        .chat-message.user {
            text-align: right;
        }

        .chat-message.bot {
            text-align: left;
        }

        .conversation-starters {
            display: flex;
            justify-content: space-around;
            margin-bottom: 10px;
        }

        .conversation-starters button {
            flex: 1;
            margin: 0 5px;
        }

        .btn-minimize {
            position: absolute;
            right: 5px;
            top: 5px;
            color: white;
            font-size: 1.2em;
        }
    </style>
</head>
<body>
    <div class="chat-container" id="chatContainer">
        <div class="chat-header" onclick="toggleChat()">
            Car Rental Assistant
            <span class="btn-minimize" id="minimizeBtn">&ndash;</span>
        </div>
        <div class="chat-body" id="chatBody">
            <div class="conversation-starters">
                <button class="btn btn-outline-primary btn-sm" onclick="sendMessage('I want to rent a car')">Rent a Car</button>
                <button class="btn btn-outline-primary btn-sm" onclick="sendMessage('What cars do you have?')">Available Cars</button>
                <button class="btn btn-outline-primary btn-sm" onclick="sendMessage('How much does it cost?')">Pricing</button>
            </div>
            <div id="messages"></div>
        </div>
        <div class="chat-footer" id="chatFooter">
            <input type="text" id="userInput" class="form-control" placeholder="Type a message...">
            <button class="btn btn-primary mt-2" onclick="sendMessage()">Send</button>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <script>
        function toggleChat() {
            const chatBody = document.getElementById('chatBody');
            const chatFooter = document.getElementById('chatFooter');
            const minimizeBtn = document.getElementById('minimizeBtn');
            if (chatBody.style.display === 'none') {
                chatBody.style.display = 'block';
                chatFooter.style.display = 'block';
                minimizeBtn.innerHTML = '&ndash;';
            } else {
                chatBody.style.display = 'none';
                chatFooter.style.display = 'none';
                minimizeBtn.innerHTML = '+';
            }
        }

        function appendMessage(text, sender) {
            const messageClass = sender === 'user' ? 'user' : 'bot';
            const message = `<div class="chat-message ${messageClass}">${text}</div>`;
            $('#messages').append(message);
            $('#chatBody').scrollTop($('#chatBody')[0].scrollHeight);
        }

        async function sendMessage(text) {
            const userInput = text || $('#userInput').val();
            if (userInput.trim() === '') return;

            appendMessage(userInput, 'user');
            $('#userInput').val('');

            try {
                const response = await fetch('/openai-chat', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/json' },
                    body: JSON.stringify({ message: userInput })
                });
                const data = await response.json();
                appendMessage(data.reply, 'bot');

                if (data.extractedFields) {
                    fetchCarRecommendations(data.extractedFields);
                }
            } catch (error) {
                appendMessage("Sorry, there was an error processing your request.", 'bot');
                console.error('Error:', error);
            }
        }

        async function fetchCarRecommendations(fields) {
            const apiUrl = `https://api.example.com/cars?location=${fields.location}&carType=${fields.carType}`;
            try {
                const response = await fetch(apiUrl);
                const data = await response.json();

                if (data.cars && data.cars.length > 0) {
                    appendMessage("Here are some cars you might like:", 'bot');
                    data.cars.forEach(car => {
                        appendMessage(`${car.name} - ${car.price}`, 'bot');
                    });
                } else {
                    appendMessage("No cars found for your criteria.", 'bot');
                }
            } catch (error) {
                appendMessage("There was an error fetching car recommendations.", 'bot');
                console.error('Error fetching car recommendations:', error);
            }
        }

        // Automatically open the chat on page load (optional)
        document.addEventListener('DOMContentLoaded', () => {
            toggleChat();
        });
    </script>
</body>
</html>
