<?php

require 'vendor/autoload.php';
require 'NotORM.php';

//require 'dbconfig.php';

use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;
use Slim\App;
use Slim\Container;

// instantiate the App object
$app = new \Slim\App();

// Get the DI container
$container = $app->getContainer();

// Add database connection settings to the container
$container['db'] = function () {
    $pdo = new PDO('mysql:host=localhost;dbname=oppozipy_apex;charset=utf8', 'oppozipy_apexuser', '!3]GnzeTv#fR');
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    return $pdo;
};

// Add NotORM instance to the container
$container['notorm'] = function ($c) {
    return new NotORM($c['db']);
};

$app->get('/', function (Request $request, Response $response) {
    return $response->write("Welcome to API");
});

// Customers Endpoints
// Customers Endpoints
$app->get('/customers_all', function (Request $request, Response $response) {
    $db = $this->get('notorm');
    $customers = array();
    foreach ($db->Customers() as $customer) {
        $customers[] = $customer;
    }
    return $response->withJson($customers);
});

$app->get('/customers/{id}', function (Request $request, Response $response, array $args) {
    $db = $this->get('notorm');
    $id = $args['id'];
    $customer = $db->Customers()->where('CustomerID', $id)->fetch();
    if ($customer) {
        return $response->withJson($customer);
    } else {
        return $response->withStatus(404)->withJson(['error' => 'Customer not found']);
    }
});

$app->post('/customers', function (Request $request, Response $response) {
    $db = $this->get('notorm');
    $data = $request->getParsedBody();
    $result = $db->Customers()->insert($data);
    return $response->withJson($result);
});

$app->put('/customers/{id}', function (Request $request, Response $response, array $args) {
    $db = $this->get('notorm');
    $id = $args['id'];
    $data = $request->getParsedBody();
    $customer = $db->Customers()->where('CustomerID', $id);
    if ($customer->fetch()) {
        $result = $customer->update($data);
        return $response->withJson($result);
    } else {
        return $response->withStatus(404)->withJson(['error' => 'Customer not found']);
    }
});

$app->delete('/customers/{id}', function (Request $request, Response $response, array $args) {
    $db = $this->get('notorm');
    $id = $args['id'];
    $customer = $db->Customers()->where('CustomerID', $id);
    if ($customer->fetch()) {
        $result = $customer->delete();
        return $response->withJson($result);
    } else {
        return $response->withStatus(404)->withJson(['error' => 'Customer not found']);
    }
});

// Similar Endpoints for Cars
$app->get('/cars', function (Request $request, Response $response) {
    $db = $this->get('notorm');
    $cars = array();
    foreach ($db->Cars() as $car) {
        $cars[] = $car;
    }
    return $response->withJson($cars);
});

$app->get('/cars/{id}', function (Request $request, Response $response, array $args) {
    $db = $this->get('notorm');
    $id = $args['id'];
    $car = $db->Cars()->where('CarID', $id)->fetch();
    if ($car) {
        return $response->withJson($car);
    } else {
        return $response->withStatus(404)->withJson(['error' => 'Car not found']);
    }
});

$app->post('/cars', function (Request $request, Response $response) {
    $db = $this->get('notorm');
    $data = $request->getParsedBody();
    $result = $db->Cars()->insert($data);
    return $response->withJson($result);
});

$app->put('/cars/{id}', function (Request $request, Response $response, array $args) {
    $db = $this->get('notorm');
    $id = $args['id'];
    $data = $request->getParsedBody();
    $car = $db->Cars()->where('CarID', $id);
    if ($car->fetch()) {
        $result = $car->update($data);
        return $response->withJson($result);
    } else {
        return $response->withStatus(404)->withJson(['error' => 'Car not found']);
    }
});

$app->put('/carsimages/{id}/{filename}/{imagenumber}', function (Request $request, Response $response, array $args) {
    $db = $this->get('notorm');
    $id = $args['id'];
    $filename = $args['filename'];
    $imagenumber = $args['imagenumber'];
    $imagecolumn = "ImageLink".$imagenumber ;
    
    $data = array ($imagecolumn => $filename);
    $car = $db->Cars()->where('CarID', $id);
    if ($car->fetch()) {
        $result = $car->update($data);
        return $response->withJson($result);
    } else {
        return $response->withStatus(404)->withJson(['error' => 'Car not found']);
    }
});

$app->delete('/cars/{id}', function (Request $request, Response $response, array $args) {
    $db = $this->get('notorm');
    $id = $args['id'];
    $car = $db->Cars()->where('CarID', $id);
    if ($car->fetch()) {
        $result = $car->delete();
        return $response->withJson($result);
    } else {
        return $response->withStatus(404)->withJson(['error' => 'Car not found']);
    }
});

// Rentals Endpoints
$app->get('/rentals', function (Request $request, Response $response) {
    $db = $this->get('notorm');
    $rentals = array();
    foreach ($db->Rentals() as $rental) {
        $rentals[] = $rental;
    }
    return $response->withJson($rentals);
});

$app->get('/rentals/{id}', function (Request $request, Response $response, array $args) {
    $db = $this->get('notorm');
    $id = $args['id'];
    $rental = $db->Rentals()->where('RentalID', $id)->fetch();
    if ($rental) {
        return $response->withJson($rental);
    } else {
        return $response->withStatus(404)->withJson(['error' => 'Rental not found']);
    }
});

$app->post('/rentals', function (Request $request, Response $response) {
    $db = $this->get('notorm');
    $data = $request->getParsedBody();
    $result = $db->Rentals()->insert($data);
    return $response->withJson($result);
});

$app->put('/rentals/{id}', function (Request $request, Response $response, array $args) {
    $db = $this->get('notorm');
    $id = $args['id'];
    $data = $request->getParsedBody();
    $rental = $db->Rentals()->where('RentalID', $id);
    if ($rental->fetch()) {
        $result = $rental->update($data);
        return $response->withJson($result);
    } else {
        return $response->withStatus(404)->withJson(['error' => 'Rental not found']);
    }
});

$app->delete('/rentals/{id}', function (Request $request, Response $response, array $args) {
    $db = $this->get('notorm');
    $id = $args['id'];
    $rental = $db->Rentals()->where('RentalID', $id);
    if ($rental->fetch()) {
        $result = $rental->delete();
        return $response->withJson($result);
    } else {
        return $response->withStatus(404)->withJson(['error' => 'Rental not found']);
    }
});

// Payments Endpoints
$app->get('/payments', function (Request $request, Response $response) {
    $db = $this->get('notorm');
    $payments = array();
    foreach ($db->Payments() as $payment) {
        $payments[] = $payment;
    }
    return $response->withJson($payments);
});

$app->get('/payments/{id}', function (Request $request, Response $response, array $args) {
    $db = $this->get('notorm');
    $id = $args['id'];
    $payment = $db->Payments()->where('PaymentID', $id)->fetch();
    if ($payment) {
        return $response->withJson($payment);
    } else {
        return $response->withStatus(404)->withJson(['error' => 'Payment not found']);
    }
});

$app->post('/payments', function (Request $request, Response $response) {
    $db = $this->get('notorm');
    $data = $request->getParsedBody();
    $result = $db->Payments()->insert($data);
    return $response->withJson($result);
});

$app->put('/payments/{id}', function (Request $request, Response $response, array $args) {
    $db = $this->get('notorm');
    $id = $args['id'];
    $data = $request->getParsedBody();
    $payment = $db->Payments()->where('PaymentID', $id);
    if ($payment->fetch()) {
        $result = $payment->update($data);
        return $response->withJson($result);
    } else {
        return $response->withStatus(404)->withJson(['error' => 'Payment not found']);
    }
});

$app->delete('/payments/{id}', function (Request $request, Response $response, array $args) {
    $db = $this->get('notorm');
    $id = $args['id'];
    $payment = $db->Payments()->where('PaymentID', $id);
    if ($payment->fetch()) {
        $result = $payment->delete();
        return $response->withJson($result);
    } else {
        return $response->withStatus(404)->withJson(['error' => 'Payment not found']);
    }
});

// Reservations Endpoints
$app->get('/reservations', function (Request $request, Response $response) {
    $db = $this->get('notorm');
    $reservations = array();
    foreach ($db->Reservations() as $reservation) {
        $reservations[] = $reservation;
    }
    return $response->withJson($reservations);
});

$app->get('/reservations/{id}', function (Request $request, Response $response, array $args) {
    $db = $this->get('notorm');
    $id = $args['id'];
    $reservation = $db->Reservations()->where('ReservationID', $id)->fetch();
    if ($reservation) {
        return $response->withJson($reservation);
    } else {
        return $response->withStatus(404)->withJson(['error' => 'Reservation not found']);
    }
});

$app->post('/reservations', function (Request $request, Response $response) {
    $db = $this->get('notorm');
    $data = $request->getParsedBody();
    $result = $db->Reservations()->insert($data);
    return $response->withJson($result);
});

$app->put('/reservations/{id}', function (Request $request, Response $response, array $args) {
    $db = $this->get('notorm');
    $id = $args['id'];
    $data = $request->getParsedBody();
    $reservation = $db->Reservations()->where('ReservationID', $id);
    if ($reservation->fetch()) {
        $result = $reservation->update($data);
        return $response->withJson($result);
    } else {
        return $response->withStatus(404)->withJson(['error' => 'Reservation not found']);
    }
});

$app->delete('/reservations/{id}', function (Request $request, Response $response, array $args) {
    $db = $this->get('notorm');
    $id = $args['id'];
    $reservation = $db->Reservations()->where('ReservationID', $id);
    if ($reservation->fetch()) {
        $result = $reservation->delete();
        return $response->withJson($result);
    } else {
        return $response->withStatus(404)->withJson(['error' => 'Reservation not found']);
    }
});

$app->post('/upload', function (Request $request, Response $response, $args) {
    $directory = __DIR__ . '/uploads'; // Directory where the image will be uploaded

    // Ensure the directory exists
    if (!is_dir($directory)) {
        mkdir($directory, 0777, true);
    }

    $uploadedFiles = $request->getUploadedFiles();
    if (empty($uploadedFiles['image'])) {
        return $response->withStatus(400)->write('No image uploaded');
    }

    $uploadedFile = $uploadedFiles['image'];

    if ($uploadedFile->getError() === UPLOAD_ERR_OK) {
        $filename = moveUploadedFile($directory, $uploadedFile);
        $response->getBody()->write($filename);
        return $response;
    }

    return $response->withStatus(500)->write('Failed to upload image');
});

// Helper function to move the uploaded file
function moveUploadedFile($directory, $uploadedFile)
{
    $extension = pathinfo($uploadedFile->getClientFilename(), PATHINFO_EXTENSION);
    $basename = bin2hex(random_bytes(8)); // Generate a random name
    $filename = sprintf('%s.%0.8s', $basename, $extension);

    $uploadedFile->moveTo($directory . DIRECTORY_SEPARATOR . $filename);

    return $filename;
}


// Run the Slim application
$app->run();
?>
